/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.stream.binder.JavaClassMimeTypeUtils;
import org.springframework.cloud.stream.binder.MessageValues;
import org.springframework.core.serializer.support.SerializationFailedException;
import org.springframework.integration.codec.Codec;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ObjectUtils;

public abstract class MessageSerializationUtils {
    private static final Map<String, Class<?>> payloadTypeCache = new ConcurrentHashMap();

    public static MessageValues serializePayload(Message<?> message, Codec codec) {
        Object originalPayload = message.getPayload();
        Object originalContentType = message.getHeaders().get((Object)"contentType");
        String contentType = JavaClassMimeTypeUtils.mimeTypeFromObject(originalPayload, ObjectUtils.nullSafeToString((Object)originalContentType)).toString();
        byte[] payload = MessageSerializationUtils.serializePayload(originalPayload, codec);
        MessageValues messageValues = new MessageValues(message);
        messageValues.setPayload(payload);
        messageValues.put("contentType", (Object)contentType);
        if (originalContentType != null && !originalContentType.toString().equals(contentType.toString())) {
            messageValues.put("originalContentType", (Object)originalContentType.toString());
        }
        return messageValues;
    }

    public static byte[] serializePayload(Object originalPayload, Codec codec) {
        if (originalPayload instanceof byte[]) {
            return (byte[])originalPayload;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (originalPayload instanceof String) {
                return ((String)originalPayload).getBytes("UTF-8");
            }
            codec.encode(originalPayload, (OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationFailedException("unable to serialize payload [" + originalPayload.getClass().getName() + "]", (Throwable)e);
        }
    }

    public static MessageValues deserializePayload(MessageValues messageValues, ContentTypeResolver contentTypeResolver, Codec codec) {
        MimeType contentType;
        Object originalPayload = messageValues.getPayload();
        Object payload = MessageSerializationUtils.deserializePayload(originalPayload, contentType = contentTypeResolver.resolve(new MessageHeaders(messageValues.getHeaders())), codec);
        if (payload != null) {
            messageValues.setPayload(payload);
            Object originalContentType = messageValues.get("originalContentType");
            if (originalContentType != null) {
                messageValues.put("contentType", originalContentType);
                messageValues.remove("originalContentType");
            }
        }
        return messageValues;
    }

    private static Object deserializePayload(Object payload, MimeType contentType, Codec codec) {
        if (payload instanceof byte[]) {
            if (contentType == null || MimeTypeUtils.APPLICATION_OCTET_STREAM.equals((Object)contentType)) {
                return payload;
            }
            return MessageSerializationUtils.deserializePayload((byte[])payload, contentType, payloadTypeCache, codec);
        }
        return payload;
    }

    private static Object deserializePayload(byte[] bytes, MimeType contentType, Map<String, Class<?>> payloadTypeCache, Codec codec) {
        if ("text".equalsIgnoreCase(contentType.getType()) || MessageSerializationUtils.equalMimeTypeAndSubType(MimeTypeUtils.APPLICATION_JSON, contentType)) {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                String errorMessage = "unable to deserialize [java.lang.String]. Encoding not supported. " + e.getMessage();
                throw new SerializationFailedException(errorMessage, (Throwable)e);
            }
        }
        String className = JavaClassMimeTypeUtils.classNameFromMimeType(contentType);
        if (className == null) {
            return bytes;
        }
        try {
            Class targetType = payloadTypeCache.get(className);
            if (targetType == null) {
                targetType = ClassUtils.forName((String)className, null);
                payloadTypeCache.put(className, targetType);
            }
            return codec.decode(bytes, targetType);
        }
        catch (Exception e) {
            String errorMessage = "Unable to deserialize [" + className + "] using the contentType [" + contentType + "] " + e.getMessage();
            throw new SerializationFailedException(errorMessage, (Throwable)e);
        }
    }

    private static boolean equalMimeTypeAndSubType(MimeType m1, MimeType m2) {
        return m1.getType().equals(m2.getType()) && m1.getSubtype().equals(m2.getSubtype());
    }
}

