/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.springframework.cassandra.core.ReservedKeyword;
import org.springframework.util.Assert;

public final class CqlIdentifier
implements Comparable<CqlIdentifier>,
Serializable {
    private static final long serialVersionUID = -974441606330912437L;
    public static final String UNQUOTED_REGEX = "(?i)[a-z][\\w]*";
    public static final Pattern UNQUOTED = Pattern.compile("(?i)[a-z][\\w]*");
    public static final String QUOTED_REGEX = "(?i)[a-z]([\\w]*(\"\")+[\\w]*)+";
    public static final Pattern QUOTED = Pattern.compile("(?i)[a-z]([\\w]*(\"\")+[\\w]*)+");
    private String identifier;
    private String unquoted;
    private boolean quoted;

    public static CqlIdentifier cqlId(CharSequence identifier) {
        return new CqlIdentifier(identifier);
    }

    public static CqlIdentifier cqlId(CharSequence identifier, boolean forceQuote) {
        return new CqlIdentifier(identifier, forceQuote);
    }

    public static CqlIdentifier quotedCqlId(CharSequence identifier) {
        return new CqlIdentifier(identifier, true);
    }

    public static boolean isUnquotedIdentifier(CharSequence chars) {
        return UNQUOTED.matcher(chars).matches() && !ReservedKeyword.isReserved(chars);
    }

    public static boolean isQuotedIdentifier(CharSequence chars) {
        return QUOTED.matcher(chars).matches() || ReservedKeyword.isReserved(chars);
    }

    public CqlIdentifier(CharSequence identifier) {
        this(identifier, false);
    }

    public CqlIdentifier(CharSequence identifier, boolean forceQuote) {
        this.setIdentifier(identifier, forceQuote);
    }

    private void setIdentifier(CharSequence identifier, boolean forceQuoting) {
        Assert.notNull((Object)identifier, (String)"Identifier must not be null");
        String string = identifier.toString();
        Assert.hasText((String)string, (String)"Identifier must not be empty");
        if (forceQuoting || CqlIdentifier.isQuotedIdentifier(string)) {
            this.unquoted = string;
            this.identifier = "\"" + string + "\"";
            this.quoted = true;
        } else if (CqlIdentifier.isUnquotedIdentifier(string)) {
            this.identifier = this.unquoted = string.toLowerCase();
        } else {
            throw new IllegalArgumentException(String.format("given string [%s] is not a valid quoted or unquoted identifier", identifier));
        }
    }

    public String getUnquoted() {
        return this.unquoted;
    }

    public String toCql() {
        return this.identifier;
    }

    public StringBuilder toCql(StringBuilder builder) {
        return (builder != null ? builder : new StringBuilder()).append(this.toCql());
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    @Override
    public int compareTo(CqlIdentifier identifier) {
        int comparison = Boolean.valueOf(this.quoted).compareTo(identifier.quoted);
        return comparison != 0 ? comparison : this.identifier.compareTo(identifier.identifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CqlIdentifier) && !(obj instanceof CharSequence)) {
            return false;
        }
        CqlIdentifier that = obj instanceof CqlIdentifier ? (CqlIdentifier)obj : CqlIdentifier.cqlId((CharSequence)obj);
        return this.quoted == that.quoted && this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return Boolean.valueOf(this.quoted).hashCode() ^ this.identifier.hashCode();
    }

    public String toString() {
        return this.toCql();
    }
}

