/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql.generator;

import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.cassandra.core.cql.generator.UserTypeNameCqlGenerator;
import org.springframework.cassandra.core.keyspace.CreateUserTypeSpecification;
import org.springframework.cassandra.core.keyspace.FieldSpecification;
import org.springframework.util.Assert;

public class CreateUserTypeCqlGenerator
extends UserTypeNameCqlGenerator<CreateUserTypeSpecification> {
    public static String toCql(CreateUserTypeSpecification specification) {
        return new CreateUserTypeCqlGenerator(specification).toCql();
    }

    public CreateUserTypeCqlGenerator(CreateUserTypeSpecification specification) {
        super(specification);
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        Assert.notNull((Object)((CreateUserTypeSpecification)this.getSpecification()).getName(), (String)"User type name must not be null");
        Assert.isTrue((!((CreateUserTypeSpecification)this.getSpecification()).getFields().isEmpty() ? 1 : 0) != 0, (String)String.format("User type [%s] does not contain fields", ((CreateUserTypeSpecification)this.getSpecification()).getName()));
        return this.columns(this.preambleCql(cql)).append(";");
    }

    private StringBuilder preambleCql(StringBuilder cql) {
        return CqlStringUtils.noNull(cql).append("CREATE TYPE ").append(((CreateUserTypeSpecification)this.spec()).getIfNotExists() ? "IF NOT EXISTS " : "").append(((CreateUserTypeSpecification)this.spec()).getName());
    }

    private StringBuilder columns(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        cql.append(" (");
        boolean first = true;
        for (FieldSpecification column : ((CreateUserTypeSpecification)this.spec()).getFields()) {
            if (!first) {
                cql.append(", ");
            }
            column.toCql(cql);
            first = false;
        }
        cql.append(")");
        return cql;
    }
}

