/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing.config;

import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.util.Assert;

public class AnnotationAuditingConfiguration
implements AuditingConfiguration {
    private final AnnotationAttributes attributes;

    public AnnotationAuditingConfiguration(AnnotationMetadata metadata, Class<? extends Annotation> annotation) {
        Assert.notNull((Object)metadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull(annotation, (String)"Annotation must not be null!");
        this.attributes = new AnnotationAttributes(metadata.getAnnotationAttributes(annotation.getName()));
    }

    @Override
    public String getAuditorAwareRef() {
        return this.attributes.getString("auditorAwareRef");
    }

    @Override
    public boolean isSetDates() {
        return this.attributes.getBoolean("setDates");
    }

    @Override
    public String getDateTimeProviderRef() {
        return this.attributes.getString("dateTimeProviderRef");
    }

    @Override
    public boolean isModifyOnCreate() {
        return this.attributes.getBoolean("modifyOnCreate");
    }
}

