/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.ArrayList;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.PropertyValueConverterFactory;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.convert.ValueConverterRegistry;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.lang.Nullable;

public class SimplePropertyValueConversions
implements PropertyValueConversions,
InitializingBean {
    @Nullable
    private PropertyValueConverterFactory converterFactory;
    @Nullable
    private ValueConverterRegistry<?> valueConverterRegistry;
    private boolean converterCacheEnabled = true;

    public void setConverterFactory(PropertyValueConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    @Nullable
    public PropertyValueConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    private PropertyValueConverterFactory obtainConverterFactory() {
        PropertyValueConverterFactory factory = this.getConverterFactory();
        if (factory == null) {
            throw new IllegalStateException("PropertyValueConverterFactory is not set. Make sure to either set the converter factory or call afterPropertiesSet() to initialize the object.");
        }
        return factory;
    }

    public void setValueConverterRegistry(ValueConverterRegistry<?> valueConverterRegistry) {
        this.valueConverterRegistry = valueConverterRegistry;
    }

    @Nullable
    public ValueConverterRegistry<?> getValueConverterRegistry() {
        return this.valueConverterRegistry;
    }

    public void setConverterCacheEnabled(boolean converterCacheEnabled) {
        this.converterCacheEnabled = converterCacheEnabled;
    }

    @Override
    public boolean hasValueConverter(PersistentProperty<?> property) {
        return this.obtainConverterFactory().getConverter(property) != null;
    }

    @Nullable
    public <DV, SV, C extends PersistentProperty<C>, D extends ValueConversionContext<C>> PropertyValueConverter<DV, SV, D> getValueConverter(C property) {
        return this.obtainConverterFactory().getConverter(property);
    }

    public void init() {
        ArrayList<PropertyValueConverterFactory> factoryList = new ArrayList<PropertyValueConverterFactory>(3);
        if (this.converterFactory != null) {
            factoryList.add(this.converterFactory);
        } else {
            factoryList.add(PropertyValueConverterFactory.simple());
        }
        if (this.valueConverterRegistry != null && !this.valueConverterRegistry.isEmpty()) {
            factoryList.add(PropertyValueConverterFactory.configuredInstance(this.valueConverterRegistry));
        }
        PropertyValueConverterFactory targetFactory = factoryList.size() > 1 ? PropertyValueConverterFactory.chained(factoryList) : (PropertyValueConverterFactory)factoryList.iterator().next();
        this.converterFactory = this.converterCacheEnabled ? PropertyValueConverterFactory.caching(targetFactory) : targetFactory;
    }

    public void afterPropertiesSet() {
        this.init();
    }
}

