/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.function.BiFunction;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.lang.Nullable;

public interface PropertyValueConverter<DV, SV, C extends ValueConversionContext<? extends PersistentProperty<?>>> {
    @Nullable
    public DV read(@Nullable SV var1, C var2);

    @Nullable
    public SV write(@Nullable DV var1, C var2);

    public static class FunctionPropertyValueConverter<DV, SV, P extends PersistentProperty<P>>
    implements PropertyValueConverter<DV, SV, ValueConversionContext<P>> {
        private final BiFunction<DV, ValueConversionContext<P>, SV> writer;
        private final BiFunction<SV, ValueConversionContext<P>, DV> reader;

        public FunctionPropertyValueConverter(BiFunction<DV, ValueConversionContext<P>, SV> writer, BiFunction<SV, ValueConversionContext<P>, DV> reader) {
            this.writer = writer;
            this.reader = reader;
        }

        @Override
        @Nullable
        public SV write(@Nullable DV value, ValueConversionContext<P> context) {
            return this.writer.apply(value, context);
        }

        @Override
        @Nullable
        public DV read(@Nullable SV value, ValueConversionContext<P> context) {
            return this.reader.apply(value, context);
        }
    }

    public static enum ObjectToObjectPropertyValueConverter implements PropertyValueConverter
    {
        INSTANCE;


        @Nullable
        public Object read(@Nullable Object value, ValueConversionContext context) {
            return value;
        }

        @Nullable
        public Object write(@Nullable Object value, ValueConversionContext context) {
            return value;
        }
    }
}

