/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ReactiveTypeDescriptor;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.ProxyUtils;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class ReactiveWrappers {
    private static final boolean PROJECT_REACTOR_PRESENT = ClassUtils.isPresent((String)"reactor.core.publisher.Flux", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final boolean RXJAVA3_PRESENT = ClassUtils.isPresent((String)"io.reactivex.rxjava3.core.Flowable", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final boolean KOTLIN_COROUTINES_PRESENT = ClassUtils.isPresent((String)"kotlinx.coroutines.reactor.MonoKt", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final boolean MUTINY_PRESENT = ClassUtils.isPresent((String)"io.smallrye.mutiny.Multi", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final Map<Class<?>, Boolean> IS_REACTIVE_TYPE = new ConcurrentReferenceHashMap();
    private static final boolean IS_REACTIVE_AVAILABLE = Arrays.stream(ReactiveLibrary.values()).anyMatch(ReactiveWrappers::isAvailable);

    private ReactiveWrappers() {
    }

    public static boolean isAvailable() {
        return IS_REACTIVE_AVAILABLE;
    }

    public static boolean isAvailable(ReactiveLibrary reactiveLibrary) {
        Assert.notNull((Object)((Object)reactiveLibrary), (String)"Reactive library must not be null!");
        switch (reactiveLibrary) {
            case PROJECT_REACTOR: {
                return PROJECT_REACTOR_PRESENT;
            }
            case RXJAVA3: {
                return RXJAVA3_PRESENT;
            }
            case KOTLIN_COROUTINES: {
                return PROJECT_REACTOR_PRESENT && KOTLIN_COROUTINES_PRESENT;
            }
            case MUTINY: {
                return MUTINY_PRESENT;
            }
        }
        throw new IllegalArgumentException(String.format("Reactive library %s not supported", new Object[]{reactiveLibrary}));
    }

    public static boolean supports(Class<?> type) {
        return ReactiveWrappers.isAvailable() && IS_REACTIVE_TYPE.computeIfAbsent(type, key -> ReactiveWrappers.isWrapper(ProxyUtils.getUserClass(key))) != false;
    }

    public static boolean usesReactiveType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return Arrays.stream(type.getMethods()).flatMap(ReflectionUtils::returnTypeAndParameters).anyMatch(ReactiveWrappers::supports);
    }

    public static boolean isNoValueType(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.findDescriptor(type).map(ReactiveTypeDescriptor::isNoValue).orElse(false);
    }

    public static boolean isSingleValueType(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.findDescriptor(type).map(it -> !it.isMultiValue() && !it.isNoValue()).orElse(false);
    }

    public static boolean isMultiValueType(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.isSingleValueType(type) ? false : ReactiveWrappers.findDescriptor(type).map(ReactiveTypeDescriptor::isMultiValue).orElse(false);
    }

    private static boolean isWrapper(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.isNoValueType(type) || ReactiveWrappers.isSingleValueType(type) || ReactiveWrappers.isMultiValueType(type);
    }

    private static Optional<ReactiveTypeDescriptor> findDescriptor(Class<?> type) {
        Assert.notNull(type, (String)"Wrapper type must not be null!");
        ReactiveAdapterRegistry adapterRegistry = ReactiveWrapperConverters.RegistryHolder.REACTIVE_ADAPTER_REGISTRY;
        if (adapterRegistry == null) {
            return Optional.empty();
        }
        ReactiveAdapter adapter = adapterRegistry.getAdapter(type);
        if (adapter != null && adapter.getDescriptor().isDeferred()) {
            return Optional.of(adapter.getDescriptor());
        }
        return Optional.empty();
    }

    public static enum ReactiveLibrary {
        PROJECT_REACTOR,
        RXJAVA3,
        KOTLIN_COROUTINES,
        MUTINY;

    }
}

