/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.util.NullableWrapperConverters;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class VavrCollectionConverters {
    private static final boolean VAVR_PRESENT = ClassUtils.isPresent((String)"io.vavr.control.Option", (ClassLoader)NullableWrapperConverters.class.getClassLoader());

    public static Collection<Object> getConvertersToRegister() {
        if (!VAVR_PRESENT) {
            return Collections.emptyList();
        }
        return Arrays.asList(new Object[]{ToJavaConverter.INSTANCE, FromJavaConverter.INSTANCE});
    }

    public static enum ToJavaConverter implements ConditionalGenericConverter
    {
        INSTANCE;

        private static final TypeDescriptor TRAVERSAL_TYPE;
        private static final java.util.Set<Class<?>> COLLECTIONS_AND_MAP;

        @NonNull
        public java.util.Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return COLLECTIONS_AND_MAP.stream().map(it -> new GenericConverter.ConvertiblePair(Traversable.class, it)).collect(Collectors.toSet());
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return sourceType.isAssignableTo(TRAVERSAL_TYPE) && COLLECTIONS_AND_MAP.contains(targetType.getType());
        }

        @Nullable
        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return null;
            }
            if (source instanceof Seq) {
                return ((Seq)source).asJava();
            }
            if (source instanceof Map) {
                return ((Map)source).toJavaMap();
            }
            if (source instanceof Set) {
                return ((Set)source).toJavaSet();
            }
            throw new IllegalArgumentException("Unsupported Vavr collection " + source.getClass());
        }

        static {
            TRAVERSAL_TYPE = TypeDescriptor.valueOf(Traversable.class);
            COLLECTIONS_AND_MAP = new HashSet<Class>(Arrays.asList(Collection.class, List.class, java.util.Set.class, java.util.Map.class));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FromJavaConverter implements ConditionalGenericConverter
    {
        INSTANCE{

            @NonNull
            public java.util.Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                return CONVERTIBLE_PAIRS;
            }

            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (sourceType.isCollection() && Map.class.isAssignableFrom(targetType.getType())) {
                    return false;
                }
                return !sourceType.isMap() || Map.class.isAssignableFrom(targetType.getType()) || targetType.getType().equals(Traversable.class);
            }

            @Nullable
            public Object convert(@Nullable Object source, TypeDescriptor sourceDescriptor, TypeDescriptor targetDescriptor) {
                Class targetType = targetDescriptor.getType();
                if (Seq.class.isAssignableFrom(targetType)) {
                    return io.vavr.collection.List.ofAll((Iterable)((Iterable)source));
                }
                if (Set.class.isAssignableFrom(targetType)) {
                    return LinkedHashSet.ofAll((Iterable)((Iterable)source));
                }
                if (Map.class.isAssignableFrom(targetType)) {
                    return LinkedHashMap.ofAll((java.util.Map)((java.util.Map)source));
                }
                if (source instanceof List) {
                    return io.vavr.collection.List.ofAll((Iterable)((Iterable)source));
                }
                if (source instanceof java.util.Set) {
                    return LinkedHashSet.ofAll((Iterable)((Iterable)source));
                }
                if (source instanceof java.util.Map) {
                    return LinkedHashMap.ofAll((java.util.Map)((java.util.Map)source));
                }
                return source;
            }
        };

        private static final java.util.Set<GenericConverter.ConvertiblePair> CONVERTIBLE_PAIRS;

        static {
            HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
            pairs.add(new GenericConverter.ConvertiblePair(Collection.class, Traversable.class));
            pairs.add(new GenericConverter.ConvertiblePair(java.util.Map.class, Traversable.class));
            CONVERTIBLE_PAIRS = Collections.unmodifiableSet(pairs);
        }
    }
}

