/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;

@FunctionalInterface
public interface ManagedTypes {
    public static ManagedTypes empty() {
        return ManagedTypes.fromIterable(Collections.emptySet());
    }

    public static ManagedTypes fromIterable(Iterable<? extends Class<?>> types) {
        Assert.notNull(types, (String)"Types must not be null");
        return types::forEach;
    }

    public static ManagedTypes fromStream(Stream<? extends Class<?>> types) {
        Assert.notNull(types, (String)"Types must not be null");
        return types::forEach;
    }

    public static ManagedTypes fromSupplier(final Supplier<Iterable<Class<?>>> dataProvider) {
        Assert.notNull(dataProvider, (String)"Supplier must not be null");
        return new ManagedTypes(){
            final Lazy<Iterable<Class<?>>> lazyProvider;
            {
                this.lazyProvider = Lazy.of(dataProvider);
            }

            @Override
            public void forEach(Consumer<Class<?>> action) {
                this.lazyProvider.get().forEach(action);
            }
        };
    }

    public void forEach(Consumer<Class<?>> var1);

    default public List<Class<?>> toList() {
        ArrayList list = new ArrayList(100);
        this.forEach(list::add);
        return list;
    }
}

