/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.suggest.SuggestRequestBuilder;
import org.elasticsearch.action.suggest.SuggestResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.CriteriaFilterProcessor;
import org.springframework.data.elasticsearch.core.CriteriaQueryProcessor;
import org.springframework.data.elasticsearch.core.DefaultResultMapper;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.MappingBuilder;
import org.springframework.data.elasticsearch.core.MultiGetResultMapper;
import org.springframework.data.elasticsearch.core.ResultsExtractor;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.data.elasticsearch.core.SearchResultMapper;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.aggregation.impl.AggregatedPageImpl;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.facet.FacetRequest;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ElasticsearchTemplate
implements ElasticsearchOperations,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchTemplate.class);
    private Client client;
    private ElasticsearchConverter elasticsearchConverter;
    private ResultsMapper resultsMapper;
    private String searchTimeout;

    public ElasticsearchTemplate(Client client) {
        this(client, new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()));
    }

    public ElasticsearchTemplate(Client client, EntityMapper entityMapper) {
        this(client, (ElasticsearchConverter)new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()), entityMapper);
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter, EntityMapper entityMapper) {
        this(client, elasticsearchConverter, new DefaultResultMapper(elasticsearchConverter.getMappingContext(), entityMapper));
    }

    public ElasticsearchTemplate(Client client, ResultsMapper resultsMapper) {
        this(client, (ElasticsearchConverter)new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()), resultsMapper);
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter) {
        this(client, elasticsearchConverter, new DefaultResultMapper(elasticsearchConverter.getMappingContext()));
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter, ResultsMapper resultsMapper) {
        Assert.notNull((Object)client, (String)"Client must not be null!");
        Assert.notNull((Object)elasticsearchConverter, (String)"ElasticsearchConverter must not be null!");
        Assert.notNull((Object)resultsMapper, (String)"ResultsMapper must not be null!");
        this.client = client;
        this.elasticsearchConverter = elasticsearchConverter;
        this.resultsMapper = resultsMapper;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    public void setSearchTimeout(String searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    @Override
    public <T> boolean createIndex(Class<T> clazz) {
        return this.createIndexIfNotCreated(clazz);
    }

    @Override
    public boolean createIndex(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        return ((CreateIndexResponse)this.client.admin().indices().create(Requests.createIndexRequest((String)indexName)).actionGet()).isAcknowledged();
    }

    @Override
    public <T> boolean putMapping(Class<T> clazz) {
        if (clazz.isAnnotationPresent(Mapping.class)) {
            String mappingPath = clazz.getAnnotation(Mapping.class).mappingPath();
            if (StringUtils.isNotBlank((String)mappingPath)) {
                String mappings = ElasticsearchTemplate.readFileFromClasspath(mappingPath);
                if (StringUtils.isNotBlank((String)mappings)) {
                    return this.putMapping(clazz, mappings);
                }
            } else {
                logger.info("mappingPath in @Mapping has to be defined. Building mappings using @Field");
            }
        }
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        XContentBuilder xContentBuilder = null;
        try {
            xContentBuilder = MappingBuilder.buildMapping(clazz, persistentEntity.getIndexType(), ((ElasticsearchPersistentProperty)persistentEntity.getIdProperty()).getFieldName(), persistentEntity.getParentType());
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), e);
        }
        return this.putMapping(clazz, xContentBuilder);
    }

    @Override
    public <T> boolean putMapping(Class<T> clazz, Object mapping) {
        return this.putMapping(this.getPersistentEntityFor(clazz).getIndexName(), this.getPersistentEntityFor(clazz).getIndexType(), mapping);
    }

    @Override
    public boolean putMapping(String indexName, String type, Object mapping) {
        Assert.notNull((Object)indexName, (String)"No index defined for putMapping()");
        Assert.notNull((Object)type, (String)"No type defined for putMapping()");
        PutMappingRequestBuilder requestBuilder = this.client.admin().indices().preparePutMapping(new String[]{indexName}).setType(type);
        if (mapping instanceof String) {
            requestBuilder.setSource(String.valueOf(mapping));
        } else if (mapping instanceof Map) {
            requestBuilder.setSource((Map)mapping);
        } else if (mapping instanceof XContentBuilder) {
            requestBuilder.setSource((XContentBuilder)mapping);
        }
        return ((PutMappingResponse)requestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    public Map getMapping(String indexName, String type) {
        Assert.notNull((Object)indexName, (String)"No index defined for putMapping()");
        Assert.notNull((Object)type, (String)"No type defined for putMapping()");
        Map mappings = null;
        try {
            mappings = ((MappingMetaData)((ImmutableOpenMap)((GetMappingsResponse)this.client.admin().indices().getMappings((GetMappingsRequest)((GetMappingsRequest)new GetMappingsRequest().indices(new String[]{indexName})).types(new String[]{type})).actionGet()).getMappings().get((Object)indexName)).get((Object)type)).getSourceAsMap();
        }
        catch (Exception e) {
            throw new ElasticsearchException("Error while getting mapping for indexName : " + indexName + " type : " + type + " " + e.getMessage());
        }
        return mappings;
    }

    @Override
    public <T> Map getMapping(Class<T> clazz) {
        return this.getMapping(this.getPersistentEntityFor(clazz).getIndexName(), this.getPersistentEntityFor(clazz).getIndexType());
    }

    @Override
    public ElasticsearchConverter getElasticsearchConverter() {
        return this.elasticsearchConverter;
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz) {
        return this.queryForObject(query, clazz, this.resultsMapper);
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz, GetResultMapper mapper) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        GetResponse response = (GetResponse)this.client.prepareGet(persistentEntity.getIndexName(), persistentEntity.getIndexType(), query.getId()).execute().actionGet();
        T entity = mapper.mapResult(response, clazz);
        return entity;
    }

    @Override
    public <T> T queryForObject(CriteriaQuery query, Class<T> clazz) {
        Page<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    @Override
    public <T> T queryForObject(StringQuery query, Class<T> clazz) {
        Page<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    public <T> AggregatedPage<T> queryForPage(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, (Class)clazz, (SearchResultMapper)this.resultsMapper);
    }

    public <T> AggregatedPage<T> queryForPage(SearchQuery query, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.doSearch(this.prepareSearch(query, clazz), query);
        return mapper.mapResults(response, clazz, query.getPageable());
    }

    @Override
    public <T> T query(SearchQuery query, ResultsExtractor<T> resultsExtractor) {
        SearchResponse response = this.doSearch(this.prepareSearch(query), query);
        return resultsExtractor.extract(response);
    }

    @Override
    public <T> List<T> queryForList(CriteriaQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    @Override
    public <T> List<T> queryForList(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    @Override
    public <T> List<T> queryForList(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, (Class)clazz).getContent();
    }

    @Override
    public <T> List<String> queryForIds(SearchQuery query) {
        SearchRequestBuilder request = this.prepareSearch(query).setQuery(query.getQuery()).setNoFields();
        if (query.getFilter() != null) {
            request.setPostFilter(query.getFilter());
        }
        SearchResponse response = this.getSearchResponse((ListenableActionFuture<SearchResponse>)request.execute());
        return this.extractIds(response);
    }

    @Override
    public <T> Page<T> queryForPage(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        SearchRequestBuilder searchRequestBuilder = this.prepareSearch(criteriaQuery, clazz);
        if (elasticsearchQuery != null) {
            searchRequestBuilder.setQuery(elasticsearchQuery);
        } else {
            searchRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (criteriaQuery.getMinScore() > 0.0f) {
            searchRequestBuilder.setMinScore(criteriaQuery.getMinScore());
        }
        if (elasticsearchFilter != null) {
            searchRequestBuilder.setPostFilter(elasticsearchFilter);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("doSearch query:\n" + searchRequestBuilder.toString());
        }
        SearchResponse response = this.getSearchResponse((ListenableActionFuture<SearchResponse>)searchRequestBuilder.execute());
        return this.resultsMapper.mapResults(response, clazz, criteriaQuery.getPageable());
    }

    @Override
    public <T> Page<T> queryForPage(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz, (SearchResultMapper)this.resultsMapper);
    }

    @Override
    public <T> Page<T> queryForPage(StringQuery query, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.getSearchResponse((ListenableActionFuture<SearchResponse>)this.prepareSearch(query, clazz).setQuery(query.getSource()).execute());
        return mapper.mapResults(response, clazz, query.getPageable());
    }

    @Override
    public <T> CloseableIterator<T> stream(CriteriaQuery query, Class<T> clazz) {
        long scrollTimeInMillis = TimeValue.timeValueMinutes((long)1L).millis();
        String initScrollId = this.scan(query, scrollTimeInMillis, false, clazz);
        return this.doStream(initScrollId, scrollTimeInMillis, clazz, this.resultsMapper);
    }

    @Override
    public <T> CloseableIterator<T> stream(SearchQuery query, Class<T> clazz) {
        return this.stream(query, clazz, this.resultsMapper);
    }

    @Override
    public <T> CloseableIterator<T> stream(SearchQuery query, Class<T> clazz, SearchResultMapper mapper) {
        long scrollTimeInMillis = TimeValue.timeValueMinutes((long)1L).millis();
        String initScrollId = this.scan(query, scrollTimeInMillis, false, clazz);
        return this.doStream(initScrollId, scrollTimeInMillis, clazz, mapper);
    }

    private <T> CloseableIterator<T> doStream(final String initScrollId, final long scrollTimeInMillis, final Class<T> clazz, final SearchResultMapper mapper) {
        return new CloseableIterator<T>(){
            private volatile Iterator<T> currentHits;
            private volatile String scrollId;
            private volatile boolean finished;
            {
                this.scrollId = initScrollId;
            }

            public void close() {
                try {
                    if (!this.finished && this.scrollId != null && this.currentHits != null && this.currentHits.hasNext()) {
                        ElasticsearchTemplate.this.client.prepareClearScroll().addScrollId(this.scrollId).execute().actionGet();
                    }
                }
                finally {
                    this.currentHits = null;
                    this.scrollId = null;
                }
            }

            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                if (this.currentHits == null || !this.currentHits.hasNext()) {
                    SearchResponse response = ElasticsearchTemplate.this.getSearchResponse((ListenableActionFuture<SearchResponse>)ElasticsearchTemplate.this.client.prepareSearchScroll(this.scrollId).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute());
                    this.currentHits = mapper.mapResults(response, clazz, null).iterator();
                    this.finished = !this.currentHits.hasNext();
                    this.scrollId = response.getScrollId();
                }
                return this.currentHits.hasNext();
            }

            public T next() {
                if (this.hasNext()) {
                    return this.currentHits.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public <T> long count(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        if (elasticsearchFilter == null) {
            return this.doCount(this.prepareCount(criteriaQuery, clazz), elasticsearchQuery);
        }
        return this.doCount(this.prepareSearch(criteriaQuery, clazz), elasticsearchQuery, elasticsearchFilter);
    }

    @Override
    public <T> long count(SearchQuery searchQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = searchQuery.getQuery();
        QueryBuilder elasticsearchFilter = searchQuery.getFilter();
        if (elasticsearchFilter == null) {
            return this.doCount(this.prepareCount(searchQuery, clazz), elasticsearchQuery);
        }
        return this.doCount(this.prepareSearch(searchQuery, clazz), elasticsearchQuery, elasticsearchFilter);
    }

    @Override
    public <T> long count(CriteriaQuery query) {
        return this.count(query, null);
    }

    @Override
    public <T> long count(SearchQuery query) {
        return this.count(query, null);
    }

    private long doCount(CountRequestBuilder countRequestBuilder, QueryBuilder elasticsearchQuery) {
        if (elasticsearchQuery != null) {
            countRequestBuilder.setQuery(elasticsearchQuery);
        }
        return ((CountResponse)countRequestBuilder.execute().actionGet()).getCount();
    }

    private long doCount(SearchRequestBuilder searchRequestBuilder, QueryBuilder elasticsearchQuery, QueryBuilder elasticsearchFilter) {
        if (elasticsearchQuery != null) {
            searchRequestBuilder.setQuery(elasticsearchQuery);
        } else {
            searchRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (elasticsearchFilter != null) {
            searchRequestBuilder.setPostFilter(elasticsearchFilter);
        }
        searchRequestBuilder.setSearchType(SearchType.COUNT);
        return ((SearchResponse)searchRequestBuilder.execute().actionGet()).getHits().getTotalHits();
    }

    private <T> CountRequestBuilder prepareCount(Query query, Class<T> clazz) {
        String[] indexName = !CollectionUtils.isEmpty(query.getIndices()) ? query.getIndices().toArray(new String[query.getIndices().size()]) : this.retrieveIndexNameFromPersistentEntity(clazz);
        String[] types = !CollectionUtils.isEmpty(query.getTypes()) ? query.getTypes().toArray(new String[query.getTypes().size()]) : this.retrieveTypeFromPersistentEntity(clazz);
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        CountRequestBuilder countRequestBuilder = this.client.prepareCount(indexName);
        if (types != null) {
            countRequestBuilder.setTypes(types);
        }
        return countRequestBuilder;
    }

    @Override
    public <T> LinkedList<T> multiGet(SearchQuery searchQuery, Class<T> clazz) {
        return this.resultsMapper.mapResults(this.getMultiResponse(searchQuery, clazz), clazz);
    }

    private <T> MultiGetResponse getMultiResponse(Query searchQuery, Class<T> clazz) {
        String indexName = !CollectionUtils.isEmpty(searchQuery.getIndices()) ? searchQuery.getIndices().get(0) : this.getPersistentEntityFor(clazz).getIndexName();
        String type = !CollectionUtils.isEmpty(searchQuery.getTypes()) ? searchQuery.getTypes().get(0) : this.getPersistentEntityFor(clazz).getIndexType();
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Assert.notNull((Object)type, (String)"No type define for Query");
        Assert.notEmpty(searchQuery.getIds(), (String)"No Id define for Query");
        MultiGetRequestBuilder builder = this.client.prepareMultiGet();
        for (String id : searchQuery.getIds()) {
            MultiGetRequest.Item item = new MultiGetRequest.Item(indexName, type, id);
            if (searchQuery.getRoute() != null) {
                item = item.routing(searchQuery.getRoute());
            }
            if (searchQuery.getFields() != null && !searchQuery.getFields().isEmpty()) {
                item = item.fields(ElasticsearchTemplate.toArray(searchQuery.getFields()));
            }
            builder.add(item);
        }
        return (MultiGetResponse)builder.execute().actionGet();
    }

    @Override
    public <T> LinkedList<T> multiGet(SearchQuery searchQuery, Class<T> clazz, MultiGetResultMapper getResultMapper) {
        return getResultMapper.mapResults(this.getMultiResponse(searchQuery, clazz), clazz);
    }

    @Override
    public String index(IndexQuery query) {
        String documentId = ((IndexResponse)this.prepareIndex(query).execute().actionGet()).getId();
        if (query.getObject() != null) {
            this.setPersistentEntityId(query.getObject(), documentId);
        }
        return documentId;
    }

    @Override
    public UpdateResponse update(UpdateQuery query) {
        return (UpdateResponse)this.prepareUpdate(query).execute().actionGet();
    }

    private UpdateRequestBuilder prepareUpdate(UpdateQuery query) {
        String indexName = StringUtils.isNotBlank((String)query.getIndexName()) ? query.getIndexName() : this.getPersistentEntityFor(query.getClazz()).getIndexName();
        String type = StringUtils.isNotBlank((String)query.getType()) ? query.getType() : this.getPersistentEntityFor(query.getClazz()).getIndexType();
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Assert.notNull((Object)type, (String)"No type define for Query");
        Assert.notNull((Object)query.getId(), (String)"No Id define for Query");
        Assert.notNull((Object)query.getUpdateRequest(), (String)"No IndexRequest define for Query");
        UpdateRequestBuilder updateRequestBuilder = this.client.prepareUpdate(indexName, type, query.getId());
        updateRequestBuilder.setRouting(query.getUpdateRequest().routing());
        if (query.getUpdateRequest().script() == null) {
            if (query.DoUpsert()) {
                updateRequestBuilder.setDocAsUpsert(true).setDoc(query.getUpdateRequest().doc());
            } else {
                updateRequestBuilder.setDoc(query.getUpdateRequest().doc());
            }
        } else {
            updateRequestBuilder.setScript(query.getUpdateRequest().script());
        }
        return updateRequestBuilder;
    }

    @Override
    public void bulkIndex(List<IndexQuery> queries) {
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (IndexQuery query : queries) {
            bulkRequest.add(this.prepareIndex(query));
        }
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
        if (bulkResponse.hasFailures()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), item.getFailureMessage());
            }
            throw new ElasticsearchException("Bulk indexing has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + "]", failedDocuments);
        }
    }

    @Override
    public void bulkUpdate(List<UpdateQuery> queries) {
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (UpdateQuery query : queries) {
            bulkRequest.add(this.prepareUpdate(query));
        }
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
        if (bulkResponse.hasFailures()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), item.getFailureMessage());
            }
            throw new ElasticsearchException("Bulk indexing has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + "]", failedDocuments);
        }
    }

    @Override
    public <T> boolean indexExists(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public boolean indexExists(String indexName) {
        return ((IndicesExistsResponse)this.client.admin().indices().exists(Requests.indicesExistsRequest((String[])new String[]{indexName})).actionGet()).isExists();
    }

    @Override
    public boolean typeExists(String index, String type) {
        return ((ClusterStateResponse)this.client.admin().cluster().prepareState().execute().actionGet()).getState().metaData().index(index).getMappings().containsKey((Object)type);
    }

    @Override
    public <T> boolean deleteIndex(Class<T> clazz) {
        return this.deleteIndex(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public boolean deleteIndex(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for delete operation");
        if (this.indexExists(indexName)) {
            return ((DeleteIndexResponse)this.client.admin().indices().delete(new DeleteIndexRequest(indexName)).actionGet()).isAcknowledged();
        }
        return false;
    }

    @Override
    public String delete(String indexName, String type, String id) {
        return ((DeleteResponse)this.client.prepareDelete(indexName, type, id).execute().actionGet()).getId();
    }

    @Override
    public <T> String delete(Class<T> clazz, String id) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        return this.delete(persistentEntity.getIndexName(), persistentEntity.getIndexType(), id);
    }

    @Override
    public <T> void delete(DeleteQuery deleteQuery, Class<T> clazz) {
        String indexName = StringUtils.isNotBlank((String)deleteQuery.getIndex()) ? deleteQuery.getIndex() : this.getPersistentEntityFor(clazz).getIndexName();
        String typeName = StringUtils.isNotBlank((String)deleteQuery.getType()) ? deleteQuery.getType() : this.getPersistentEntityFor(clazz).getIndexType();
        Integer pageSize = deleteQuery.getPageSize() != null ? deleteQuery.getPageSize() : 1000;
        Long scrollTimeInMillis = deleteQuery.getScrollTimeInMillis() != null ? deleteQuery.getScrollTimeInMillis() : 10000L;
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(deleteQuery.getQuery()).withIndices(indexName).withTypes(typeName).withPageable((Pageable)new PageRequest(0, pageSize.intValue())).build();
        String scrollId = this.scan(searchQuery, (long)scrollTimeInMillis, true);
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        ArrayList ids = new ArrayList();
        boolean hasRecords = true;
        while (hasRecords) {
            Page<T> page = this.scroll(scrollId, (long)scrollTimeInMillis, new SearchResultMapper(){

                @Override
                public <T> AggregatedPage<T> mapResults(SearchResponse response, Class<T> clazz, Pageable pageable) {
                    ArrayList<String> result = new ArrayList<String>();
                    for (SearchHit searchHit : response.getHits()) {
                        String id = searchHit.getId();
                        result.add(id);
                    }
                    if (result.size() > 0) {
                        return new AggregatedPageImpl(result);
                    }
                    return null;
                }
            });
            if (page != null && page.getContent().size() > 0) {
                ids.addAll(page.getContent());
                continue;
            }
            hasRecords = false;
        }
        for (String id : ids) {
            bulkRequestBuilder.add(this.client.prepareDelete(indexName, typeName, id));
        }
        if (bulkRequestBuilder.numberOfActions() > 0) {
            bulkRequestBuilder.execute().actionGet();
        }
        this.clearScroll(scrollId);
    }

    @Override
    public void delete(DeleteQuery deleteQuery) {
        Assert.notNull((Object)deleteQuery.getIndex(), (String)"No index defined for Query");
        Assert.notNull((Object)deleteQuery.getType(), (String)"No type define for Query");
        this.delete(deleteQuery, null);
    }

    @Override
    public <T> void delete(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        Assert.notNull((Object)elasticsearchQuery, (String)"Query can not be null.");
        DeleteQuery deleteQuery = new DeleteQuery();
        deleteQuery.setQuery(elasticsearchQuery);
        this.delete(deleteQuery, clazz);
    }

    @Override
    public String scan(CriteriaQuery criteriaQuery, long scrollTimeInMillis, boolean noFields) {
        return this.doScan(this.prepareScan(criteriaQuery, scrollTimeInMillis, noFields), criteriaQuery);
    }

    @Override
    public <T> String scan(CriteriaQuery criteriaQuery, long scrollTimeInMillis, boolean noFields, Class<T> clazz) {
        return this.doScan(this.prepareScan(criteriaQuery, scrollTimeInMillis, noFields, clazz), criteriaQuery);
    }

    @Override
    public String scan(SearchQuery searchQuery, long scrollTimeInMillis, boolean noFields) {
        return this.doScan(this.prepareScan(searchQuery, scrollTimeInMillis, noFields), searchQuery);
    }

    @Override
    public <T> String scan(SearchQuery searchQuery, long scrollTimeInMillis, boolean noFields, Class<T> clazz) {
        return this.doScan(this.prepareScan(searchQuery, scrollTimeInMillis, noFields, clazz), searchQuery);
    }

    private <T> SearchRequestBuilder prepareScan(Query query, long scrollTimeInMillis, boolean noFields, Class<T> clazz) {
        this.setPersistentEntityIndexAndType(query, clazz);
        return this.prepareScan(query, scrollTimeInMillis, noFields);
    }

    private SearchRequestBuilder prepareScan(Query query, long scrollTimeInMillis, boolean noFields) {
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(ElasticsearchTemplate.toArray(query.getIndices())).setSearchType(SearchType.SCAN).setTypes(ElasticsearchTemplate.toArray(query.getTypes())).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).setFrom(0).setSize(query.getPageable().getPageSize());
        if (!CollectionUtils.isEmpty(query.getFields())) {
            requestBuilder.addFields(ElasticsearchTemplate.toArray(query.getFields()));
        }
        if (noFields) {
            requestBuilder.setNoFields();
        }
        return requestBuilder;
    }

    private String doScan(SearchRequestBuilder requestBuilder, CriteriaQuery criteriaQuery) {
        Assert.notNull((Object)criteriaQuery.getIndices(), (String)"No index defined for Query");
        Assert.notNull((Object)criteriaQuery.getTypes(), (String)"No type define for Query");
        Assert.notNull((Object)criteriaQuery.getPageable(), (String)"Query.pageable is required for scan & scroll");
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        if (elasticsearchQuery != null) {
            requestBuilder.setQuery(elasticsearchQuery);
        } else {
            requestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (elasticsearchFilter != null) {
            requestBuilder.setPostFilter(elasticsearchFilter);
        }
        return this.getSearchResponse((ListenableActionFuture<SearchResponse>)requestBuilder.execute()).getScrollId();
    }

    private String doScan(SearchRequestBuilder requestBuilder, SearchQuery searchQuery) {
        Assert.notNull(searchQuery.getIndices(), (String)"No index defined for Query");
        Assert.notNull(searchQuery.getTypes(), (String)"No type define for Query");
        Assert.notNull((Object)searchQuery.getPageable(), (String)"Query.pageable is required for scan & scroll");
        if (searchQuery.getFilter() != null) {
            requestBuilder.setPostFilter(searchQuery.getFilter());
        }
        return this.getSearchResponse((ListenableActionFuture<SearchResponse>)requestBuilder.setQuery(searchQuery.getQuery()).execute()).getScrollId();
    }

    @Override
    public <T> Page<T> scroll(String scrollId, long scrollTimeInMillis, Class<T> clazz) {
        SearchResponse response = this.getSearchResponse((ListenableActionFuture<SearchResponse>)this.client.prepareSearchScroll(scrollId).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute());
        return this.resultsMapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> Page<T> scroll(String scrollId, long scrollTimeInMillis, SearchResultMapper mapper) {
        SearchResponse response = this.getSearchResponse((ListenableActionFuture<SearchResponse>)this.client.prepareSearchScroll(scrollId).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute());
        return mapper.mapResults(response, null, null);
    }

    @Override
    public void clearScroll(String scrollId) {
        this.client.prepareClearScroll().addScrollId(scrollId).execute().actionGet();
    }

    @Override
    public <T> Page<T> moreLikeThis(MoreLikeThisQuery query, Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        String indexName = StringUtils.isNotBlank((String)query.getIndexName()) ? query.getIndexName() : persistentEntity.getIndexName();
        String type = StringUtils.isNotBlank((String)query.getType()) ? query.getType() : persistentEntity.getIndexType();
        Assert.notNull((Object)indexName, (String)"No 'indexName' defined for MoreLikeThisQuery");
        Assert.notNull((Object)type, (String)"No 'type' defined for MoreLikeThisQuery");
        Assert.notNull((Object)query.getId(), (String)"No document id defined for MoreLikeThisQuery");
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery().addLikeItem(new MoreLikeThisQueryBuilder.Item[]{new MoreLikeThisQueryBuilder.Item(indexName, type, query.getId())});
        if (query.getMinTermFreq() != null) {
            moreLikeThisQueryBuilder.minTermFreq(query.getMinTermFreq().intValue());
        }
        if (query.getMaxQueryTerms() != null) {
            moreLikeThisQueryBuilder.maxQueryTerms(query.getMaxQueryTerms().intValue());
        }
        if (!CollectionUtils.isEmpty(query.getStopWords())) {
            moreLikeThisQueryBuilder.stopWords(ElasticsearchTemplate.toArray(query.getStopWords()));
        }
        if (query.getMinDocFreq() != null) {
            moreLikeThisQueryBuilder.minDocFreq(query.getMinDocFreq().intValue());
        }
        if (query.getMaxDocFreq() != null) {
            moreLikeThisQueryBuilder.maxDocFreq(query.getMaxDocFreq().intValue());
        }
        if (query.getMinWordLen() != null) {
            moreLikeThisQueryBuilder.minWordLength(query.getMinWordLen().intValue());
        }
        if (query.getMaxWordLen() != null) {
            moreLikeThisQueryBuilder.maxWordLength(query.getMaxWordLen().intValue());
        }
        if (query.getBoostTerms() != null) {
            moreLikeThisQueryBuilder.boostTerms(query.getBoostTerms().floatValue());
        }
        return this.queryForPage((SearchQuery)new NativeSearchQueryBuilder().withQuery((QueryBuilder)moreLikeThisQueryBuilder).build(), (Class)clazz);
    }

    private SearchResponse doSearch(SearchRequestBuilder searchRequest, SearchQuery searchQuery) {
        if (searchQuery.getFilter() != null) {
            searchRequest.setPostFilter(searchQuery.getFilter());
        }
        if (!CollectionUtils.isEmpty(searchQuery.getElasticsearchSorts())) {
            for (SortBuilder sort : searchQuery.getElasticsearchSorts()) {
                searchRequest.addSort(sort);
            }
        }
        if (!searchQuery.getScriptFields().isEmpty()) {
            searchRequest.addField("_source");
            for (ScriptField scriptedField : searchQuery.getScriptFields()) {
                searchRequest.addScriptField(scriptedField.fieldName(), scriptedField.script());
            }
        }
        if (searchQuery.getHighlightFields() != null) {
            for (HighlightBuilder.Field highlightField : searchQuery.getHighlightFields()) {
                searchRequest.addHighlightedField(highlightField);
            }
        }
        if (!CollectionUtils.isEmpty(searchQuery.getIndicesBoost())) {
            for (IndexBoost indexBoost : searchQuery.getIndicesBoost()) {
                searchRequest.addIndexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!CollectionUtils.isEmpty(searchQuery.getAggregations())) {
            for (AbstractAggregationBuilder aggregationBuilder : searchQuery.getAggregations()) {
                searchRequest.addAggregation(aggregationBuilder);
            }
        }
        if (!CollectionUtils.isEmpty(searchQuery.getFacets())) {
            for (FacetRequest aggregatedFacet : searchQuery.getFacets()) {
                searchRequest.addAggregation(aggregatedFacet.getFacet());
            }
        }
        return this.getSearchResponse((ListenableActionFuture<SearchResponse>)searchRequest.setQuery(searchQuery.getQuery()).execute());
    }

    private SearchResponse getSearchResponse(ListenableActionFuture<SearchResponse> response) {
        return this.searchTimeout == null ? (SearchResponse)response.actionGet() : (SearchResponse)response.actionGet(this.searchTimeout);
    }

    private <T> boolean createIndexIfNotCreated(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName()) || this.createIndexWithSettings(clazz);
    }

    private <T> boolean createIndexWithSettings(Class<T> clazz) {
        if (clazz.isAnnotationPresent(Setting.class)) {
            String settingPath = clazz.getAnnotation(Setting.class).settingPath();
            if (StringUtils.isNotBlank((String)settingPath)) {
                String settings = ElasticsearchTemplate.readFileFromClasspath(settingPath);
                if (StringUtils.isNotBlank((String)settings)) {
                    return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), (Object)settings);
                }
            } else {
                logger.info("settingPath in @Setting has to be defined. Using default instead.");
            }
        }
        return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), (Object)this.getDefaultSettings(this.getPersistentEntityFor(clazz)));
    }

    @Override
    public boolean createIndex(String indexName, Object settings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.client.admin().indices().prepareCreate(indexName);
        if (settings instanceof String) {
            createIndexRequestBuilder.setSettings(String.valueOf(settings));
        } else if (settings instanceof Map) {
            createIndexRequestBuilder.setSettings((Map)settings);
        } else if (settings instanceof XContentBuilder) {
            createIndexRequestBuilder.setSettings((XContentBuilder)settings);
        }
        return ((CreateIndexResponse)createIndexRequestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    public <T> boolean createIndex(Class<T> clazz, Object settings) {
        return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), settings);
    }

    private <T> Map getDefaultSettings(ElasticsearchPersistentEntity<T> persistentEntity) {
        if (persistentEntity.isUseServerConfiguration()) {
            return new HashMap();
        }
        return new MapBuilder().put((Object)"index.number_of_shards", (Object)String.valueOf(persistentEntity.getShards())).put((Object)"index.number_of_replicas", (Object)String.valueOf(persistentEntity.getReplicas())).put((Object)"index.refresh_interval", (Object)persistentEntity.getRefreshInterval()).put((Object)"index.store.type", (Object)persistentEntity.getIndexStoreType()).map();
    }

    @Override
    public <T> Map getSetting(Class<T> clazz) {
        return this.getSetting(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public Map getSetting(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for getSettings");
        return ((Settings)((GetSettingsResponse)this.client.admin().indices().getSettings(new GetSettingsRequest()).actionGet()).getIndexToSettings().get((Object)indexName)).getAsMap();
    }

    private <T> SearchRequestBuilder prepareSearch(Query query, Class<T> clazz) {
        this.setPersistentEntityIndexAndType(query, clazz);
        return this.prepareSearch(query);
    }

    private SearchRequestBuilder prepareSearch(Query query) {
        Assert.notNull(query.getIndices(), (String)"No index defined for Query");
        Assert.notNull(query.getTypes(), (String)"No type defined for Query");
        int startRecord = 0;
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(ElasticsearchTemplate.toArray(query.getIndices())).setSearchType(query.getSearchType()).setTypes(ElasticsearchTemplate.toArray(query.getTypes()));
        if (query.getSourceFilter() != null) {
            SourceFilter sourceFilter = query.getSourceFilter();
            searchRequestBuilder.setFetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (query.getPageable() != null) {
            startRecord = query.getPageable().getPageNumber() * query.getPageable().getPageSize();
            searchRequestBuilder.setSize(query.getPageable().getPageSize());
        }
        searchRequestBuilder.setFrom(startRecord);
        if (!query.getFields().isEmpty()) {
            searchRequestBuilder.addFields(ElasticsearchTemplate.toArray(query.getFields()));
        }
        if (query.getSort() != null) {
            for (Sort.Order order : query.getSort()) {
                searchRequestBuilder.addSort(order.getProperty(), order.getDirection() == Sort.Direction.DESC ? SortOrder.DESC : SortOrder.ASC);
            }
        }
        if (query.getMinScore() > 0.0f) {
            searchRequestBuilder.setMinScore(query.getMinScore());
        }
        return searchRequestBuilder;
    }

    private IndexRequestBuilder prepareIndex(IndexQuery query) {
        try {
            String indexName = StringUtils.isBlank((String)query.getIndexName()) ? this.retrieveIndexNameFromPersistentEntity(query.getObject().getClass())[0] : query.getIndexName();
            String type = StringUtils.isBlank((String)query.getType()) ? this.retrieveTypeFromPersistentEntity(query.getObject().getClass())[0] : query.getType();
            IndexRequestBuilder indexRequestBuilder = null;
            if (query.getObject() != null) {
                String id = StringUtils.isBlank((String)query.getId()) ? this.getPersistentEntityId(query.getObject()) : query.getId();
                indexRequestBuilder = id != null ? this.client.prepareIndex(indexName, type, id) : this.client.prepareIndex(indexName, type);
                indexRequestBuilder.setSource(this.resultsMapper.getEntityMapper().mapToString(query.getObject()));
            } else if (query.getSource() != null) {
                indexRequestBuilder = this.client.prepareIndex(indexName, type, query.getId()).setSource(query.getSource());
            } else {
                throw new ElasticsearchException("object or source is null, failed to index the document [id: " + query.getId() + "]");
            }
            if (query.getVersion() != null) {
                indexRequestBuilder.setVersion(query.getVersion().longValue());
                indexRequestBuilder.setVersionType(VersionType.EXTERNAL);
            }
            if (query.getParentId() != null) {
                indexRequestBuilder.setParent(query.getParentId());
            }
            return indexRequestBuilder;
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to index the document [id: " + query.getId() + "]", e);
        }
    }

    @Override
    public void refresh(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for refresh()");
        this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{indexName})).actionGet();
    }

    @Override
    public <T> void refresh(Class<T> clazz) {
        this.refresh(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public Boolean addAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        AliasAction aliasAction = new AliasAction(AliasAction.Type.ADD, query.getIndexName(), query.getAliasName());
        if (query.getFilterBuilder() != null) {
            aliasAction.filter(query.getFilterBuilder());
        } else if (query.getFilter() != null) {
            aliasAction.filter(query.getFilter());
        } else if (StringUtils.isNotBlank((String)query.getRouting())) {
            aliasAction.routing(query.getRouting());
        } else if (StringUtils.isNotBlank((String)query.getSearchRouting())) {
            aliasAction.searchRouting(query.getSearchRouting());
        } else if (StringUtils.isNotBlank((String)query.getIndexRouting())) {
            aliasAction.indexRouting(query.getIndexRouting());
        }
        return ((IndicesAliasesResponse)this.client.admin().indices().prepareAliases().addAliasAction(aliasAction).execute().actionGet()).isAcknowledged();
    }

    @Override
    public Boolean removeAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        return ((IndicesAliasesResponse)this.client.admin().indices().prepareAliases().removeAlias(query.getIndexName(), query.getAliasName()).execute().actionGet()).isAcknowledged();
    }

    @Override
    public List<AliasMetaData> queryForAlias(String indexName) {
        return (List)((GetAliasesResponse)this.client.admin().indices().getAliases(new GetAliasesRequest().indices(new String[]{indexName})).actionGet()).getAliases().get((Object)indexName);
    }

    @Override
    public ElasticsearchPersistentEntity getPersistentEntityFor(Class clazz) {
        Assert.isTrue((boolean)clazz.isAnnotationPresent(Document.class), (String)("Unable to identify index name. " + clazz.getSimpleName() + " is not a Document. Make sure the document class is annotated with @Document(indexName=\"foo\")"));
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(clazz);
    }

    private String getPersistentEntityId(Object entity) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(entity.getClass());
        Object identifier = persistentEntity.getIdentifierAccessor(entity).getIdentifier();
        return identifier == null ? null : String.valueOf(identifier);
    }

    private void setPersistentEntityId(Object entity, String id) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(entity.getClass());
        PersistentProperty idProperty = persistentEntity.getIdProperty();
        if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
            persistentEntity.getPropertyAccessor(entity).setProperty(idProperty, (Object)id);
        }
    }

    private void setPersistentEntityIndexAndType(Query query, Class clazz) {
        if (query.getIndices().isEmpty()) {
            query.addIndices(this.retrieveIndexNameFromPersistentEntity(clazz));
        }
        if (query.getTypes().isEmpty()) {
            query.addTypes(this.retrieveTypeFromPersistentEntity(clazz));
        }
    }

    private String[] retrieveIndexNameFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return new String[]{this.getPersistentEntityFor(clazz).getIndexName()};
        }
        return null;
    }

    private String[] retrieveTypeFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return new String[]{this.getPersistentEntityFor(clazz).getIndexType()};
        }
        return null;
    }

    private List<String> extractIds(SearchResponse response) {
        ArrayList<String> ids = new ArrayList<String>();
        for (SearchHit hit : response.getHits()) {
            if (hit == null) continue;
            ids.add(hit.getId());
        }
        return ids;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (this.elasticsearchConverter instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.elasticsearchConverter).setApplicationContext(context);
        }
    }

    private static String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }

    protected ResultsMapper getResultsMapper() {
        return this.resultsMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFileFromClasspath(String url) {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        ClassPathResource classPathResource = new ClassPathResource(url);
        InputStreamReader inputStreamReader = new InputStreamReader(classPathResource.getInputStream());
        bufferedReader = new BufferedReader(inputStreamReader);
        String lineSeparator = System.getProperty("line.separator");
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line).append(lineSeparator);
        }
        if (bufferedReader == null) return stringBuilder.toString();
        try {
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException e) {
            logger.debug(String.format("Unable to close buffered reader.. %s", e.getMessage()));
        }
        return stringBuilder.toString();
        catch (Exception e) {
            String string;
            try {
                logger.debug(String.format("Failed to load file from url: %s: %s", url, e.getMessage()));
                string = null;
                if (bufferedReader == null) return string;
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.debug(String.format("Unable to close buffered reader.. %s", e2.getMessage()));
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
                return string;
            }
            catch (IOException e3) {
                logger.debug(String.format("Unable to close buffered reader.. %s", e3.getMessage()));
            }
            return string;
        }
    }

    public SuggestResponse suggest(SuggestBuilder.SuggestionBuilder<?> suggestion, String ... indices) {
        SuggestRequestBuilder suggestRequestBuilder = this.client.prepareSuggest(indices);
        suggestRequestBuilder.addSuggestion(suggestion);
        return (SuggestResponse)suggestRequestBuilder.execute().actionGet();
    }

    public SuggestResponse suggest(SuggestBuilder.SuggestionBuilder<?> suggestion, Class clazz) {
        return this.suggest(suggestion, this.retrieveIndexNameFromPersistentEntity(clazz));
    }
}

