/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DiskStoreFactoryBean
implements FactoryBean<DiskStore>,
InitializingBean,
BeanNameAware {
    private DiskStoreFactory diskStoreFactory;
    private Boolean autoCompact;
    private Boolean allowForceCompaction;
    private Integer maxOplogSize;
    private Integer timeInterval;
    private Integer queueSize;
    private Integer compactionThreshold;
    private Integer writeBufferSize;
    private GemFireCache cache;
    private String name;
    private List<DiskDir> diskDirs;
    private DiskStore diskStore;

    public DiskStore getObject() throws Exception {
        return this.diskStore;
    }

    public Class<?> getObjectType() {
        return DiskStore.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"Cache property must be set");
        this.diskStoreFactory = this.cache.createDiskStoreFactory();
        if (this.allowForceCompaction != null) {
            this.diskStoreFactory.setAllowForceCompaction(this.allowForceCompaction.booleanValue());
        }
        if (this.compactionThreshold != null) {
            this.diskStoreFactory.setCompactionThreshold(this.compactionThreshold.intValue());
        }
        if (this.autoCompact != null) {
            this.diskStoreFactory.setAutoCompact(this.autoCompact.booleanValue());
        }
        if (this.queueSize != null) {
            this.diskStoreFactory.setQueueSize(this.queueSize.intValue());
        }
        if (this.writeBufferSize != null) {
            this.diskStoreFactory.setWriteBufferSize(this.writeBufferSize.intValue());
        }
        if (this.timeInterval != null) {
            this.diskStoreFactory.setTimeInterval((long)this.timeInterval.intValue());
        }
        if (this.maxOplogSize != null) {
            this.diskStoreFactory.setMaxOplogSize((long)this.maxOplogSize.intValue());
        }
        if (!CollectionUtils.isEmpty(this.diskDirs)) {
            File[] diskDirFiles = new File[this.diskDirs.size()];
            int[] diskDirSizes = new int[this.diskDirs.size()];
            for (int i = 0; i < this.diskDirs.size(); ++i) {
                DiskDir diskDir = this.diskDirs.get(i);
                diskDirFiles[i] = new File(diskDir.location);
                diskDirSizes[i] = diskDir.maxSize == null ? Integer.MAX_VALUE : diskDir.maxSize;
            }
            this.diskStoreFactory.setDiskDirsAndSizes(diskDirFiles, diskDirSizes);
        }
        this.diskStore = this.diskStoreFactory.create(this.name == null ? "DEFAULT" : this.name);
        Assert.notNull((Object)this.diskStore);
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    public void setAutoCompact(Boolean autoCompact) {
        this.autoCompact = autoCompact;
    }

    public void setAllowForceCompaction(Boolean allowForceCompaction) {
        this.allowForceCompaction = allowForceCompaction;
    }

    public void setMaxOplogSize(Integer maxOplogSize) {
        this.maxOplogSize = maxOplogSize;
    }

    public void setTimeInterval(Integer timeInterval) {
        this.timeInterval = timeInterval;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public void setCompactionThreshold(Integer compactionThreshold) {
        this.compactionThreshold = compactionThreshold;
    }

    public void setWriteBufferSize(Integer writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public void setDiskDirs(List<DiskDir> diskDirs) {
        this.diskDirs = diskDirs;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public static class DiskDir {
        final String location;
        final Integer maxSize;

        public DiskDir(String location, int maxSize) {
            this.location = location;
            this.maxSize = maxSize;
        }

        public DiskDir(String location) {
            this.location = location;
            this.maxSize = null;
        }
    }
}

