/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Region;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SubRegionFactoryBean<K, V>
extends AttributesFactory<K, V>
implements FactoryBean<Region<K, V>>,
InitializingBean {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String name;
    private String regionName;
    private Region<K, V> subRegion;
    private Region<?, ?> parent;
    private boolean lookupOnly;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.parent, (String)"parent region must not be null");
        this.subRegion = this.parent.getSubregion(this.regionName);
        if (this.subRegion == null) {
            if (this.lookupOnly) {
                throw new BeanInitializationException("Cannot find region [" + this.regionName + "] in cache " + this.parent.getRegionService());
            }
            this.log.debug((Object)("creating subregion of [" + this.parent.getFullPath() + "] with name " + this.regionName));
            this.subRegion = this.parent.createSubregion(this.regionName, this.create());
        }
    }

    public Region<K, V> getObject() throws Exception {
        return this.subRegion;
    }

    public Class<?> getObjectType() {
        return Region.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setParent(Region<?, ?> parent) {
        this.parent = parent;
    }

    public void setLookupOnly(boolean lookupOnly) {
        this.lookupOnly = lookupOnly;
    }
}

