/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;
import org.springframework.data.gemfire.function.execution.GemfireFunctionCallback;
import org.springframework.data.gemfire.function.execution.GemfireFunctionOperations;

abstract class AbstractFunctionTemplate
implements GemfireFunctionOperations {
    protected Log log = LogFactory.getLog(this.getClass());
    protected long timeout;
    protected volatile ResultCollector<?, ?> resultCollector;

    AbstractFunctionTemplate() {
    }

    @Override
    public <T> Iterable<T> execute(Function function, Object ... args) {
        AbstractFunctionExecution functionExecution = this.getFunctionExecution().setArgs(args).setFunction(function);
        return this.execute(functionExecution);
    }

    @Override
    public <T> T executeAndExtract(Function function, Object ... args) {
        AbstractFunctionExecution functionExecution = this.getFunctionExecution().setArgs(args).setFunction(function);
        return this.executeAndExtract(functionExecution);
    }

    @Override
    public <T> Iterable<T> execute(String functionId, Object ... args) {
        AbstractFunctionExecution functionExecution = this.getFunctionExecution().setArgs(args).setFunctionId(functionId);
        return this.execute(functionExecution);
    }

    @Override
    public <T> T executeAndExtract(String functionId, Object ... args) {
        AbstractFunctionExecution functionExecution = this.getFunctionExecution().setArgs(args).setFunctionId(functionId);
        return this.executeAndExtract(functionExecution);
    }

    @Override
    public <T> T execute(GemfireFunctionCallback<T> callback) {
        Execution execution = this.getFunctionExecution().getExecution();
        return callback.doInGemfire(execution);
    }

    protected <T> Iterable<T> execute(AbstractFunctionExecution execution) {
        execution.setTimeout(this.timeout).setResultCollector(this.resultCollector);
        return execution.execute();
    }

    protected <T> T executeAndExtract(AbstractFunctionExecution execution) {
        execution.setTimeout(this.timeout).setResultCollector(this.resultCollector);
        return execution.executeAndExtract();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setResultCollector(ResultCollector<?, ?> resultCollector) {
        this.resultCollector = resultCollector;
    }

    public ResultCollector<?, ?> getResultCollector() {
        return this.resultCollector;
    }

    protected abstract AbstractFunctionExecution getFunctionExecution();
}

