/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.Iterator;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.query.GemfireQueryCreator;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.gemfire.repository.query.StringBasedGemfireRepositoryQuery;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeGemfireRepositoryQuery
extends GemfireRepositoryQuery {
    private final GemfireQueryMethod method;
    private final PartTree tree;
    private final GemfireTemplate template;

    public PartTreeGemfireRepositoryQuery(GemfireQueryMethod method, GemfireTemplate template) {
        super(method);
        Class domainClass = method.getEntityInformation().getJavaType();
        this.tree = new PartTree(method.getName(), domainClass);
        this.method = method;
        this.template = template;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor parameterAccessor = new ParametersParameterAccessor(this.method.getParameters(), parameters);
        QueryString query = new GemfireQueryCreator(this.tree, this.method.getPersistentEntity()).createQuery(parameterAccessor.getSort());
        StringBasedGemfireRepositoryQuery repositoryQuery = new StringBasedGemfireRepositoryQuery(query.toString(), this.method, this.template);
        return repositoryQuery.execute(this.prepareStringParameters(parameters));
    }

    private Object[] prepareStringParameters(Object[] parameters) {
        Iterator iterator = this.tree.getParts().iterator();
        Object[] result = new Object[parameters.length];
        block5: for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (parameter == null) {
                result[i] = parameter;
                continue;
            }
            Part.Type type = ((Part)iterator.next()).getType();
            switch (type) {
                case CONTAINING: {
                    result[i] = String.format("%%%s%%", parameter.toString());
                    continue block5;
                }
                case STARTING_WITH: {
                    result[i] = String.format("%s%%", parameter.toString());
                    continue block5;
                }
                case ENDING_WITH: {
                    result[i] = String.format("%%%s", parameter.toString());
                    continue block5;
                }
                default: {
                    result[i] = parameter;
                }
            }
        }
        return result;
    }
}

