/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.Iterator;
import org.springframework.data.gemfire.repository.query.Predicate;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

class Predicates
implements Predicate {
    private final Predicate current;

    private Predicates(Predicate predicate) {
        this.current = predicate;
    }

    private static Predicates create(Predicate predicate) {
        return new Predicates(predicate);
    }

    public static Predicates create(Part part, Iterator<Integer> value) {
        return Predicates.create(new AtomicPredicate(part, value));
    }

    public Predicates and(final Predicate predicate) {
        return Predicates.create(new Predicate(){

            @Override
            public String toString(String alias) {
                return String.format("%s AND %s", Predicates.this.current.toString(alias), predicate.toString(alias));
            }
        });
    }

    public Predicates or(final Predicate predicate) {
        return Predicates.create(new Predicate(){

            @Override
            public String toString(String alias) {
                return String.format("%s OR %s", Predicates.this.current.toString(alias), predicate.toString(alias));
            }
        });
    }

    @Override
    public String toString(String alias) {
        return this.current.toString(alias);
    }

    public static class AtomicPredicate
    implements Predicate {
        private final Part part;
        private final Iterator<Integer> value;

        public AtomicPredicate(Part part, Iterator<Integer> value) {
            Assert.notNull((Object)part);
            Assert.notNull(value);
            this.part = part;
            this.value = value;
        }

        @Override
        public String toString(String alias) {
            Part.Type type = this.part.getType();
            return String.format("%s.%s %s", alias == null ? "x" : alias, this.part.getProperty().toDotPath(), this.toClause(type));
        }

        private String toClause(Part.Type type) {
            switch (type) {
                case IS_NULL: 
                case IS_NOT_NULL: {
                    return String.format("%s NULL", this.getOperator(type));
                }
            }
            return String.format("%s $%s", this.getOperator(type), this.value.next());
        }

        private String getOperator(Part.Type type) {
            switch (type) {
                case IN: {
                    return "IN SET";
                }
                case NOT_IN: {
                    return "NOT IN SET";
                }
                case GREATER_THAN: {
                    return ">";
                }
                case GREATER_THAN_EQUAL: {
                    return ">=";
                }
                case LESS_THAN: {
                    return "<";
                }
                case LESS_THAN_EQUAL: {
                    return "<=";
                }
                case IS_NOT_NULL: 
                case NEGATING_SIMPLE_PROPERTY: {
                    return "!=";
                }
                case LIKE: 
                case STARTING_WITH: 
                case ENDING_WITH: 
                case CONTAINING: {
                    return "LIKE";
                }
                case IS_NULL: 
                case SIMPLE_PROPERTY: {
                    return "=";
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported operator %s!", type));
        }
    }
}

