/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.repository.query.Predicate;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.util.Assert;

class QueryBuilder {
    static final String DEFAULT_ALIAS = "x";
    private final String query;

    public QueryBuilder(String source) {
        Assert.hasText((String)source);
        this.query = source;
    }

    public QueryBuilder(GemfirePersistentEntity<?> entity) {
        this(String.format("SELECT * FROM /%s %s", entity.getRegionName(), DEFAULT_ALIAS));
    }

    public QueryString create(Predicate predicate) {
        return new QueryString(this.query + " WHERE " + predicate.toString(DEFAULT_ALIAS));
    }

    public String toString() {
        return this.query;
    }
}

