/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Query;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class HibernateUtils {
    private static final List<String> TYPES = Arrays.asList("org.hibernate.jpa.HibernateQuery", "org.hibernate.ejb.HibernateQuery");
    private static final Method GET_HIBERNATE_QUERY;

    private HibernateUtils() {
    }

    public static String getHibernateQuery(Object query) {
        return ((Query)ReflectionUtils.invokeMethod((Method)GET_HIBERNATE_QUERY, (Object)query)).getQueryString();
    }

    static {
        Class type = null;
        Method method = null;
        for (String typeName : TYPES) {
            try {
                type = ClassUtils.forName((String)typeName, (ClassLoader)HibernateUtils.class.getClassLoader());
                method = type.getMethod("getHibernateQuery", new Class[0]);
            }
            catch (Exception exception) {}
        }
        GET_HIBERNATE_QUERY = method;
    }
}

