/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.util.Assert;

class JpaRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<EntityManager> entityManagerBean;

    JpaRepositoryBean(BeanManager beanManager, Bean<EntityManager> entityManagerBean, Set<Annotation> qualifiers, Class<T> repositoryType, Optional<CustomRepositoryImplementationDetector> detector) {
        super(qualifiers, repositoryType, beanManager, detector);
        Assert.notNull(entityManagerBean, (String)"EntityManager bean must not be null!");
        this.entityManagerBean = entityManagerBean;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        EntityManager entityManager = (EntityManager)this.getDependencyInstance(this.entityManagerBean, EntityManager.class);
        return (T)this.create(() -> new JpaRepositoryFactory(entityManager), repositoryType);
    }
}

