/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jpa.repository.cdi.JpaRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class JpaRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private static final Log LOGGER = LogFactory.getLog(JpaRepositoryExtension.class);
    private final Map<Set<Annotation>, Bean<EntityManager>> entityManagers = new HashMap<Set<Annotation>, Bean<EntityManager>>();

    public JpaRepositoryExtension() {
        LOGGER.info((Object)"Activating CDI extension for Spring Data JPA repositories.");
    }

    <X> void processBean(@Observes ProcessBean<X> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !EntityManager.class.isAssignableFrom((Class)type)) continue;
            HashSet qualifiers = new HashSet(bean.getQualifiers());
            if (!bean.isAlternative() && this.entityManagers.containsKey(qualifiers)) continue;
            LOGGER.debug((Object)String.format("Discovered '%s' with qualifiers %s.", EntityManager.class.getName(), qualifiers));
            this.entityManagers.put(qualifiers, (Bean<EntityManager>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            CdiRepositoryBean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            LOGGER.info((Object)String.format("Registering bean for '%s' with qualifiers %s.", repositoryType.getName(), qualifiers));
            this.registerBean(repositoryBean);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    private <T> CdiRepositoryBean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<EntityManager> entityManagerBean = this.entityManagers.get(qualifiers);
        if (entityManagerBean == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", EntityManager.class.getName(), qualifiers));
        }
        return new JpaRepositoryBean<T>(beanManager, entityManagerBean, qualifiers, repositoryType, Optional.of(this.getCustomImplementationDetector()));
    }
}

