/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.query;

import java.util.Map;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.data.neo4j.support.query.QueryOperations;
import org.springframework.util.ClassUtils;

public class CypherQueryExecutor
implements QueryOperations<Map<String, Object>> {
    private final QueryEngine<Map<String, Object>> queryEngine;

    public CypherQueryExecutor(QueryEngine queryEngine) {
        this.queryEngine = ClassUtils.isPresent((String)"org.neo4j.cypher.javacompat.ExecutionEngine", (ClassLoader)this.getClass().getClassLoader()) ? queryEngine : new QueryEngine<Map<String, Object>>(){

            @Override
            public Result<Map<String, Object>> query(String statement, Map<String, Object> params) {
                throw new IllegalStateException("Cypher is not available, please add it to your dependencies to execute: " + statement);
            }
        };
    }

    @Override
    public Iterable<Map<String, Object>> queryForList(String statement, Map<String, Object> params) {
        return this.queryEngine.query(statement, params);
    }

    @Override
    public <T> Iterable<T> query(String statement, Class<T> type, Map<String, Object> params) {
        return this.queryEngine.query(statement, params).to(type);
    }

    @Override
    public <T> T queryForObject(String statement, Class<T> type, Map<String, Object> params) {
        return this.queryEngine.query(statement, params).to(type).single();
    }
}

