/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.springframework.data.neo4j.repository.query.derived.CypherFilter;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryDefinition;
import org.springframework.data.neo4j.repository.query.derived.builder.BetweenComparisonBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.BooleanComparisonBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.CypherFilterBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.DistanceComparisonBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.ExistsFilterBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.IsNullFilterBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.PropertyComparisonBuilder;
import org.springframework.data.repository.query.parser.Part;

public class CypherFinderQuery
implements DerivedQueryDefinition {
    private Class<?> entityType;
    private Part basePart;
    private List<CypherFilter> cypherFilters = new ArrayList<CypherFilter>();
    private int paramPosition = 0;

    public CypherFinderQuery(Class<?> entityType, Part basePart) {
        this.entityType = entityType;
        this.basePart = basePart;
    }

    @Override
    public Part getBasePart() {
        return this.basePart;
    }

    @Override
    public List<CypherFilter> getCypherFilters() {
        return this.cypherFilters;
    }

    @Override
    public void addPart(Part part, BooleanOperator booleanOperator) {
        List<CypherFilter> filters = this.builderForPart(part, booleanOperator).build();
        for (CypherFilter filter : filters) {
            filter.setPropertyPosition(this.paramPosition);
            this.cypherFilters.add(filter);
            this.paramPosition += filter.functionAdapter.parameterCount();
        }
    }

    private CypherFilterBuilder builderForPart(Part part, BooleanOperator booleanOperator) {
        switch (part.getType()) {
            case NEAR: {
                return new DistanceComparisonBuilder(part, booleanOperator, this.entityType);
            }
            case BETWEEN: {
                return new BetweenComparisonBuilder(part, booleanOperator, this.entityType);
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                return new IsNullFilterBuilder(part, booleanOperator, this.entityType);
            }
            case EXISTS: {
                return new ExistsFilterBuilder(part, booleanOperator, this.entityType);
            }
            case TRUE: 
            case FALSE: {
                return new BooleanComparisonBuilder(part, booleanOperator, this.entityType);
            }
        }
        return new PropertyComparisonBuilder(part, booleanOperator, this.entityType);
    }
}

