/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.repository.PagingAndSorting;
import org.springframework.data.rest.webmvc.BaseUriMethodArgumentResolver;
import org.springframework.data.rest.webmvc.PagingAndSortingMethodArgumentResolver;
import org.springframework.data.rest.webmvc.RepositoryInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RepositoryRestRequestHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Autowired
    private RepositoryRestConfiguration config;
    @Autowired
    private Repositories repositories;
    @Autowired
    private RepositoryInformationHandlerMethodArgumentResolver repoInfoResolver;
    @Autowired
    private PagingAndSortingMethodArgumentResolver pagingAndSortingResolver;
    @Autowired
    private BaseUriMethodArgumentResolver baseUriResolver;

    public boolean supportsParameter(MethodParameter parameter) {
        return RepositoryRestRequest.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        PagingAndSorting pagingAndSorting = (PagingAndSorting)this.pagingAndSortingResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        RepositoryInformation repoInfo = (RepositoryInformation)this.repoInfoResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        URI baseUri = (URI)this.baseUriResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        return new RepositoryRestRequest(this.config, this.repositories, (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class), pagingAndSorting, baseUri, repoInfo);
    }
}

