/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.repository.support.SolrRepositoryFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SolrRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    @Nullable
    private SolrClient solrClient;
    @Nullable
    private SolrOperations operations;
    private boolean schemaCreationSupport;
    @Nullable
    private SimpleSolrMappingContext solrMappingContext;
    @Nullable
    private SolrConverter solrConverter;

    public SolrRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setSolrOperations(SolrOperations operations) {
        this.operations = operations;
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public void setSchemaCreationSupport(boolean schemaCreationSupport) {
        this.schemaCreationSupport = schemaCreationSupport;
    }

    public void setSolrConverter(SolrConverter solrConverter) {
        this.solrConverter = solrConverter;
    }

    public void setSolrMappingContext(SimpleSolrMappingContext solrMappingContext) {
        this.solrMappingContext = solrMappingContext;
        super.setMappingContext((MappingContext)solrMappingContext);
    }

    @Nullable
    public SimpleSolrMappingContext getSolrMappingContext() {
        return this.solrMappingContext;
    }

    @Nullable
    protected SolrOperations getSolrOperations() {
        return this.operations;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.isTrue((this.operations != null || this.solrClient != null ? 1 : 0) != 0, (String)"SolrOperations or SolrClient must be configured!");
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        SolrRepositoryFactory factory = this.operations != null ? new SolrRepositoryFactory(this.operations) : new SolrRepositoryFactory(this.solrClient, this.solrConverter);
        factory.setSchemaCreationSupport(this.schemaCreationSupport);
        return factory;
    }
}

