/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.spec.DefaultMcpSession;
import org.springframework.ai.mcp.spec.McpError;
import org.springframework.ai.mcp.spec.McpSchema;
import org.springframework.ai.mcp.spec.McpTransport;
import org.springframework.ai.mcp.util.Utils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class McpAsyncClient {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncClient.class);
    private static TypeReference<Void> VOID_TYPE_REFERENCE = new TypeReference<Void>(){};
    private final DefaultMcpSession mcpSession;
    private McpSchema.ClientCapabilities.RootCapabilities rootCapabilities;
    private static TypeReference<McpSchema.CallToolResult> CALL_TOOL_RESULT_TYPE_REF = new TypeReference<McpSchema.CallToolResult>(){};
    private static TypeReference<McpSchema.ListToolsResult> LIST_TOOLS_RESULT_TYPE_REF = new TypeReference<McpSchema.ListToolsResult>(){};
    private static TypeReference<McpSchema.ListResourcesResult> LIST_RESOURCES_RESULT_TYPE_REF = new TypeReference<McpSchema.ListResourcesResult>(){};
    private static TypeReference<McpSchema.ReadResourceResult> READ_RESOURCE_RESULT_TYPE_REF = new TypeReference<McpSchema.ReadResourceResult>(){};
    private static TypeReference<McpSchema.ListResourceTemplatesResult> LIST_RESOURCE_TEMPLATES_RESULT_TYPE_REF = new TypeReference<McpSchema.ListResourceTemplatesResult>(){};
    private static TypeReference<McpSchema.ListPromptsResult> LIST_PROMPTS_RESULT_TYPE_REF = new TypeReference<McpSchema.ListPromptsResult>(){};
    private static TypeReference<McpSchema.GetPromptResult> GET_PROMPT_RESULT_TYPE_REF = new TypeReference<McpSchema.GetPromptResult>(){};

    public McpAsyncClient(McpTransport transport, Duration requestTimeout, List<Supplier<List<McpSchema.Root>>> rootsListProviders, boolean rootsListChangedNotification, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers) {
        HashMap<String, DefaultMcpSession.RequestHandler> requestHanlers = new HashMap<String, DefaultMcpSession.RequestHandler>();
        if (rootsListProviders != null && !rootsListProviders.isEmpty()) {
            requestHanlers.put("roots/list", this.rootsListRequestHandler(rootsListProviders));
            this.rootCapabilities = new McpSchema.ClientCapabilities.RootCapabilities(rootsListChangedNotification);
        }
        HashMap<String, DefaultMcpSession.NotificationHandler> notificationHandlers = new HashMap<String, DefaultMcpSession.NotificationHandler>();
        ArrayList<Consumer<List<McpSchema.Tool>>> toolsChangeConsumersFinal = new ArrayList<Consumer<List<McpSchema.Tool>>>();
        toolsChangeConsumersFinal.add(notification -> logger.info("Tools changed: {}", notification));
        if (!Utils.isEmpty(toolsChangeConsumers)) {
            toolsChangeConsumersFinal.addAll(toolsChangeConsumers);
        }
        notificationHandlers.put("notifications/tools/list_changed", this.toolsChangeNotificationHandler(toolsChangeConsumersFinal));
        ArrayList<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumersFinal = new ArrayList<Consumer<List<McpSchema.Resource>>>();
        resourcesChangeConsumersFinal.add(notification -> logger.info("Resources changed: {}", notification));
        if (!Utils.isEmpty(resourcesChangeConsumers)) {
            resourcesChangeConsumersFinal.addAll(resourcesChangeConsumers);
        }
        notificationHandlers.put("notifications/resources/list_changed", this.resourcesChangeNotificationHandler(resourcesChangeConsumersFinal));
        ArrayList<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumersFinal = new ArrayList<Consumer<List<McpSchema.Prompt>>>();
        promptsChangeConsumersFinal.add(notification -> logger.info("Prompts changed: {}", notification));
        if (!Utils.isEmpty(promptsChangeConsumers)) {
            promptsChangeConsumersFinal.addAll(promptsChangeConsumers);
        }
        notificationHandlers.put("notifications/prompts/list_changed", this.promptsChangeNotificationHandler(promptsChangeConsumersFinal));
        this.mcpSession = new DefaultMcpSession(requestTimeout, transport, requestHanlers, notificationHandlers);
    }

    private DefaultMcpSession.RequestHandler rootsListRequestHandler(final List<Supplier<List<McpSchema.Root>>> rootsListProviders) {
        return new DefaultMcpSession.RequestHandler(){

            @Override
            public Mono<Object> handle(Object params) {
                if (rootsListProviders == null || rootsListProviders.isEmpty()) {
                    return Mono.just(new ArrayList());
                }
                List<Mono> monos = rootsListProviders.stream().map(supplier -> Mono.fromSupplier((Supplier)supplier).subscribeOn(Schedulers.boundedElastic())).toList();
                return Mono.zip(monos, arrays -> {
                    ArrayList combinedList = new ArrayList();
                    for (Object array : arrays) {
                        List roots = (List)array;
                        combinedList.addAll(roots);
                    }
                    return combinedList;
                });
            }
        };
    }

    private DefaultMcpSession.NotificationHandler toolsChangeNotificationHandler(final List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers) {
        return new DefaultMcpSession.NotificationHandler(){

            @Override
            public Mono<Void> handle(Object params) {
                return McpAsyncClient.this.listTools().flatMap(listToolsResult -> Mono.fromRunnable(() -> {
                    for (Consumer toolsChangeConsumer : toolsChangeConsumers) {
                        toolsChangeConsumer.accept(listToolsResult.tools());
                    }
                }).subscribeOn(Schedulers.boundedElastic())).onErrorResume(error -> {
                    logger.error("Error handling tools list change notification", error);
                    return Mono.empty();
                }).then();
            }
        };
    }

    private DefaultMcpSession.NotificationHandler resourcesChangeNotificationHandler(final List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers) {
        return new DefaultMcpSession.NotificationHandler(){

            @Override
            public Mono<Void> handle(Object params) {
                return McpAsyncClient.this.listResources().flatMap(listResourcesResult -> Mono.fromRunnable(() -> {
                    for (Consumer resourceChangeConsumer : resourcesChangeConsumers) {
                        resourceChangeConsumer.accept(listResourcesResult.resources());
                    }
                }).subscribeOn(Schedulers.boundedElastic())).onErrorResume(error -> {
                    logger.error("Error handling resources list change notification", error);
                    return Mono.empty();
                }).then();
            }
        };
    }

    private DefaultMcpSession.NotificationHandler promptsChangeNotificationHandler(final List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers) {
        return new DefaultMcpSession.NotificationHandler(){

            @Override
            public Mono<Void> handle(Object params) {
                return McpAsyncClient.this.listPrompts().flatMap(listPromptsResult -> Mono.fromRunnable(() -> {
                    for (Consumer promptChangeConsumer : promptsChangeConsumers) {
                        promptChangeConsumer.accept(listPromptsResult.prompts());
                    }
                }).subscribeOn(Schedulers.boundedElastic())).onErrorResume(error -> {
                    logger.error("Error handling prompts list change notification", error);
                    return Mono.empty();
                }).then();
            }
        };
    }

    public Mono<McpSchema.InitializeResult> initialize() {
        McpSchema.InitializeRequest initializeRequest = new McpSchema.InitializeRequest("2024-11-05", new McpSchema.ClientCapabilities(null, this.rootCapabilities, null), new McpSchema.Implementation("mcp-java-client", "0.2.0"));
        Mono<McpSchema.InitializeResult> result = this.mcpSession.sendRequest("initialize", initializeRequest, new TypeReference<McpSchema.InitializeResult>(){});
        return result.flatMap(initializeResult -> {
            logger.info("Server response with Protocol: {}, Capabilities: {}, Info: {} and Instructions {}", new Object[]{initializeResult.protocolVersion(), initializeResult.capabilities(), initializeResult.serverInfo(), initializeResult.instructions()});
            if (!"2024-11-05".equals(initializeResult.protocolVersion())) {
                return Mono.error((Throwable)new McpError((Object)("Unsupported protocol version from the server: " + initializeResult.protocolVersion())));
            }
            return this.mcpSession.sendNotification("notifications/initialized", null).thenReturn(initializeResult);
        });
    }

    public Mono<Void> sendRootsListChanged() {
        return this.mcpSession.sendNotification("notifications/roots/list_changed");
    }

    public Mono<Void> ping() {
        return this.mcpSession.sendRequest("ping", null, VOID_TYPE_REFERENCE);
    }

    public Mono<McpSchema.CallToolResult> callTool(McpSchema.CallToolRequest callToolRequest) {
        return this.mcpSession.sendRequest("tools/call", callToolRequest, CALL_TOOL_RESULT_TYPE_REF);
    }

    public Mono<McpSchema.ListToolsResult> listTools() {
        return this.listTools(null);
    }

    public Mono<McpSchema.ListToolsResult> listTools(String cursor) {
        return this.mcpSession.sendRequest("tools/list", new McpSchema.PaginatedRequest(cursor), LIST_TOOLS_RESULT_TYPE_REF);
    }

    public Mono<McpSchema.ListResourcesResult> listResources() {
        return this.listResources(null);
    }

    public Mono<McpSchema.ListResourcesResult> listResources(String cursor) {
        return this.mcpSession.sendRequest("resources/list", new McpSchema.PaginatedRequest(cursor), LIST_RESOURCES_RESULT_TYPE_REF);
    }

    public Mono<McpSchema.ReadResourceResult> readResource(McpSchema.Resource resource) {
        return this.readResource(new McpSchema.ReadResourceRequest(resource.uri()));
    }

    public Mono<McpSchema.ReadResourceResult> readResource(McpSchema.ReadResourceRequest readResourceRequest) {
        return this.mcpSession.sendRequest("resources/read", readResourceRequest, READ_RESOURCE_RESULT_TYPE_REF);
    }

    public Mono<McpSchema.ListResourceTemplatesResult> listResourceTemplates() {
        return this.listResourceTemplates(null);
    }

    public Mono<McpSchema.ListResourceTemplatesResult> listResourceTemplates(String cursor) {
        return this.mcpSession.sendRequest("resources/templates/list", new McpSchema.PaginatedRequest(cursor), LIST_RESOURCE_TEMPLATES_RESULT_TYPE_REF);
    }

    public Mono<Void> sendResourcesListChanged() {
        return this.mcpSession.sendNotification("notifications/resources/list_changed");
    }

    public Mono<Void> subscribeResource(McpSchema.SubscribeRequest subscribeRequest) {
        return this.mcpSession.sendRequest("resources/subscribe", subscribeRequest, VOID_TYPE_REFERENCE);
    }

    public Mono<Void> unsubscribeResource(McpSchema.UnsubscribeRequest unsubscribeRequest) {
        return this.mcpSession.sendRequest("resources/unsubscribe", unsubscribeRequest, VOID_TYPE_REFERENCE);
    }

    public Mono<McpSchema.ListPromptsResult> listPrompts() {
        return this.listPrompts(null);
    }

    public Mono<McpSchema.ListPromptsResult> listPrompts(String cursor) {
        return this.mcpSession.sendRequest("prompts/list", new McpSchema.PaginatedRequest(cursor), LIST_PROMPTS_RESULT_TYPE_REF);
    }

    public Mono<McpSchema.GetPromptResult> getPrompt(McpSchema.GetPromptRequest getPromptRequest) {
        return this.mcpSession.sendRequest("prompts/get", getPromptRequest, GET_PROMPT_RESULT_TYPE_REF);
    }

    public Mono<Void> promptListChangedNotification() {
        return this.mcpSession.sendNotification("notifications/prompts/list_changed");
    }

    public void close() {
        this.mcpSession.close();
    }

    public Mono<Void> closeGracefully() {
        return this.mcpSession.closeGracefully();
    }
}

