/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.ai.mcp.client.McpAsyncClient;
import org.springframework.ai.mcp.client.McpSyncClient;
import org.springframework.ai.mcp.spec.McpSchema;
import org.springframework.ai.mcp.spec.McpTransport;
import org.springframework.ai.mcp.util.Assert;

public interface McpClient {
    public static Builder using(McpTransport transport) {
        return new Builder(transport);
    }

    public static class Builder {
        private final McpTransport transport;
        private Duration requestTimeout = Duration.ofSeconds(20L);
        private McpSchema.ClientCapabilities capabilities;
        private McpSchema.Implementation clientInfo = new McpSchema.Implementation("Spring AI MCP Client", "0.3.0");
        private Map<String, McpSchema.Root> roots = new HashMap<String, McpSchema.Root>();
        private List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers = new ArrayList<Consumer<List<McpSchema.Tool>>>();
        private List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers = new ArrayList<Consumer<List<McpSchema.Resource>>>();
        private List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers = new ArrayList<Consumer<List<McpSchema.Prompt>>>();
        private Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler;

        private Builder(McpTransport transport) {
            Assert.notNull(transport, "Transport must not be null");
            this.transport = transport;
        }

        public Builder requestTimeout(Duration requestTimeout) {
            Assert.notNull(requestTimeout, "Request timeout must not be null");
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder capabilities(McpSchema.ClientCapabilities capabilities) {
            Assert.notNull(capabilities, "Capabilities must not be null");
            this.capabilities = capabilities;
            return this;
        }

        public Builder clientInfo(McpSchema.Implementation clientInfo) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            return this;
        }

        public Builder roots(List<McpSchema.Root> roots) {
            Assert.notNull(roots, "Roots must not be null");
            for (McpSchema.Root root : roots) {
                this.roots.put(root.uri(), root);
            }
            return this;
        }

        public Builder roots(McpSchema.Root ... roots) {
            Assert.notNull(roots, "Roots must not be null");
            for (McpSchema.Root root : roots) {
                this.roots.put(root.uri(), root);
            }
            return this;
        }

        public Builder sampling(Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler) {
            Assert.notNull(samplingHandler, "Sampling handler must not be null");
            this.samplingHandler = samplingHandler;
            return this;
        }

        public Builder toolsChangeConsumer(Consumer<List<McpSchema.Tool>> toolsChangeConsumer) {
            Assert.notNull(toolsChangeConsumer, "Tools change consumer must not be null");
            this.toolsChangeConsumers.add(toolsChangeConsumer);
            return this;
        }

        public Builder resourcesChangeConsumer(Consumer<List<McpSchema.Resource>> resourcesChangeConsumer) {
            Assert.notNull(resourcesChangeConsumer, "Resources change consumer must not be null");
            this.resourcesChangeConsumers.add(resourcesChangeConsumer);
            return this;
        }

        public Builder promptsChangeConsumer(Consumer<List<McpSchema.Prompt>> promptsChangeConsumer) {
            Assert.notNull(promptsChangeConsumer, "Prompts change consumer must not be null");
            this.promptsChangeConsumers.add(promptsChangeConsumer);
            return this;
        }

        public McpSyncClient sync() {
            return new McpSyncClient(this.async());
        }

        public McpAsyncClient async() {
            return new McpAsyncClient(this.transport, this.requestTimeout, this.clientInfo, this.capabilities, this.roots, this.toolsChangeConsumers, this.resourcesChangeConsumers, this.promptsChangeConsumers, this.samplingHandler);
        }
    }
}

