/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.server.McpServer;
import org.springframework.ai.mcp.spec.DefaultMcpSession;
import org.springframework.ai.mcp.spec.McpError;
import org.springframework.ai.mcp.spec.McpSchema;
import org.springframework.ai.mcp.spec.McpTransport;
import org.springframework.ai.mcp.util.Utils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class McpAsyncServer {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncServer.class);
    private final DefaultMcpSession mcpSession;
    private final McpTransport transport;
    private final McpSchema.ServerCapabilities serverCapabilities;
    private final McpSchema.Implementation serverInfo;
    private final CopyOnWriteArrayList<McpServer.ToolRegistration> tools;
    private final CopyOnWriteArrayList<McpSchema.ResourceTemplate> resourceTemplates;
    private final ConcurrentHashMap<String, McpServer.ResourceRegistration> resources;
    private final ConcurrentHashMap<String, McpServer.PromptRegistration> prompts;

    public McpAsyncServer(McpTransport mcpTransport, McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<McpServer.ToolRegistration> tools, Map<String, McpServer.ResourceRegistration> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, McpServer.PromptRegistration> prompts) {
        this.serverInfo = serverInfo;
        this.tools = new CopyOnWriteArrayList<McpServer.ToolRegistration>(tools != null ? tools : List.of());
        this.resources = !Utils.isEmpty(resources) ? new ConcurrentHashMap<String, McpServer.ResourceRegistration>(resources) : new ConcurrentHashMap();
        this.resourceTemplates = !Utils.isEmpty(resourceTemplates) ? new CopyOnWriteArrayList<McpSchema.ResourceTemplate>(resourceTemplates) : new CopyOnWriteArrayList();
        ConcurrentHashMap<String, McpServer.PromptRegistration> concurrentHashMap = this.prompts = !Utils.isEmpty(prompts) ? new ConcurrentHashMap<String, McpServer.PromptRegistration>(prompts) : new ConcurrentHashMap();
        this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, null, !Utils.isEmpty(this.prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(this.resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(this.tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
        HashMap<String, DefaultMcpSession.RequestHandler> requestHandlers = new HashMap<String, DefaultMcpSession.RequestHandler>();
        requestHandlers.put("initialize", this.initializeRequestHandler());
        requestHandlers.put("ping", params -> Mono.just((Object)""));
        if (this.serverCapabilities.tools() != null) {
            requestHandlers.put("tools/list", this.toolsListRequestHandler());
            requestHandlers.put("tools/call", this.toolsCallRequestHandler());
        }
        if (!Utils.isEmpty(this.resources)) {
            requestHandlers.put("resources/list", this.resourcesListRequestHandler());
            requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
        }
        if (!Utils.isEmpty(this.resourceTemplates)) {
            requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
        }
        if (!Utils.isEmpty(this.prompts)) {
            requestHandlers.put("prompts/list", this.promptsListRequestHandler());
            requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
        }
        HashMap<String, DefaultMcpSession.NotificationHandler> notificationHandlers = new HashMap<String, DefaultMcpSession.NotificationHandler>();
        notificationHandlers.put("notifications/initialized", params -> Mono.empty());
        this.transport = mcpTransport;
        this.mcpSession = new DefaultMcpSession(Duration.ofSeconds(10L), mcpTransport, requestHandlers, notificationHandlers);
    }

    public Mono<Void> addTool(McpServer.ToolRegistration toolRegistration) {
        if (toolRegistration == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool registration must not be null"));
        }
        if (toolRegistration.tool() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool must not be null"));
        }
        if (toolRegistration.call() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool call handler must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        if (this.tools.stream().anyMatch(th -> th.tool().name().equals(toolRegistration.tool().name()))) {
            return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolRegistration.tool().name() + "' already exists")));
        }
        this.tools.add(toolRegistration);
        logger.info("Added tool handler: {}", (Object)toolRegistration.tool().name());
        if (this.serverCapabilities.tools().listChanged().booleanValue()) {
            return this.notifyToolsListChanged();
        }
        return Mono.empty();
    }

    public Mono<Void> removeTool(String toolName) {
        if (toolName == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool name must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        boolean removed = this.tools.removeIf(toolRegistration -> toolRegistration.tool().name().equals(toolName));
        if (removed) {
            logger.info("Removed tool handler: {}", (Object)toolName);
            if (this.serverCapabilities.tools().listChanged().booleanValue()) {
                return this.notifyToolsListChanged();
            }
            return Mono.empty();
        }
        return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolName + "' not found")));
    }

    public Mono<Void> addResource(McpServer.ResourceRegistration resourceHandler) {
        if (resourceHandler == null || resourceHandler.resource() == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        if (this.resources.containsKey(resourceHandler.resource().uri())) {
            return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceHandler.resource().uri() + "' already exists")));
        }
        this.resources.put(resourceHandler.resource().uri(), resourceHandler);
        logger.info("Added resource handler: {}", (Object)resourceHandler.resource().uri());
        if (this.serverCapabilities.resources().listChanged().booleanValue()) {
            return this.notifyResourcesListChanged();
        }
        return Mono.empty();
    }

    public Mono<Void> removeResource(String resourceUri) {
        if (resourceUri == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource URI must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        McpServer.ResourceRegistration removed = this.resources.remove(resourceUri);
        if (removed != null) {
            logger.info("Removed resource handler: {}", (Object)resourceUri);
            if (this.serverCapabilities.resources().listChanged().booleanValue()) {
                return this.notifyResourcesListChanged();
            }
            return Mono.empty();
        }
        return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceUri + "' not found")));
    }

    public Mono<Void> addPrompt(McpServer.PromptRegistration promptRegistration) {
        if (promptRegistration == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt registration must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        if (this.prompts.containsKey(promptRegistration.propmpt().name())) {
            return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptRegistration.propmpt().name() + "' already exists")));
        }
        this.prompts.put(promptRegistration.propmpt().name(), promptRegistration);
        logger.info("Added prompt handler: {}", (Object)promptRegistration.propmpt().name());
        if (this.serverCapabilities.prompts().listChanged().booleanValue()) {
            return this.notifyPromptsListChanged();
        }
        return Mono.empty();
    }

    public Mono<Void> removePrompt(String promptName) {
        if (promptName == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt name must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        McpServer.PromptRegistration removed = this.prompts.remove(promptName);
        if (removed != null) {
            logger.info("Removed prompt handler: {}", (Object)promptName);
            if (this.serverCapabilities.prompts().listChanged().booleanValue()) {
                return this.notifyPromptsListChanged();
            }
            return Mono.empty();
        }
        return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptName + "' not found")));
    }

    private DefaultMcpSession.RequestHandler initializeRequestHandler() {
        return params -> {
            McpSchema.InitializeRequest request = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.InitializeRequest>(){});
            logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{request.protocolVersion(), request.capabilities(), request.clientInfo()});
            if (!"2024-11-05".equals(request.protocolVersion())) {
                return Mono.error((Throwable)new McpError((Object)("Unsupported protocol version from client: " + request.protocolVersion()))).publishOn(Schedulers.boundedElastic());
            }
            return Mono.just((Object)new McpSchema.InitializeResult("2024-11-05", this.serverCapabilities, this.serverInfo, null)).publishOn(Schedulers.boundedElastic());
        };
    }

    private DefaultMcpSession.RequestHandler toolsListRequestHandler() {
        return params -> {
            McpSchema.PaginatedRequest request = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.PaginatedRequest>(){});
            List<McpSchema.Tool> tools = this.tools.stream().map(toolRegistration -> toolRegistration.tool()).toList();
            logger.info("Client tools list request - Cursor: {}", (Object)request.cursor());
            return Mono.just((Object)new McpSchema.ListToolsResult(tools, null));
        };
    }

    private DefaultMcpSession.RequestHandler toolsCallRequestHandler() {
        return params -> {
            McpSchema.CallToolRequest callToolRequest = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.CallToolRequest>(){});
            Optional<McpServer.ToolRegistration> toolRegistration = this.tools.stream().filter(tr -> callToolRequest.name().equals(tr.tool().name())).findAny();
            if (toolRegistration.isEmpty()) {
                return Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.name())));
            }
            McpSchema.CallToolResult callResponse = toolRegistration.get().call().apply(callToolRequest.arguments());
            return Mono.just((Object)callResponse);
        };
    }

    private DefaultMcpSession.RequestHandler resourcesListRequestHandler() {
        return params -> {
            McpSchema.PaginatedRequest request = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.PaginatedRequest>(){});
            List<McpSchema.Resource> resourceList = this.resources.values().stream().map(McpServer.ResourceRegistration::resource).toList();
            return Mono.just((Object)new McpSchema.ListResourcesResult(resourceList, null));
        };
    }

    private DefaultMcpSession.RequestHandler resourceTemplateListRequestHandler() {
        return params -> {
            McpSchema.PaginatedRequest request = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.PaginatedRequest>(){});
            return Mono.just((Object)new McpSchema.ListResourceTemplatesResult(this.resourceTemplates, null));
        };
    }

    private DefaultMcpSession.RequestHandler resourcesReadRequestHandler() {
        return params -> {
            McpSchema.ReadResourceRequest request = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.ReadResourceRequest>(){});
            String resourceUri = request.uri();
            if (this.resources.containsKey(resourceUri)) {
                return Mono.just((Object)this.resources.get(resourceUri).readHandler().apply(request));
            }
            return Mono.error((Throwable)new McpError((Object)("Resource not found: " + resourceUri)));
        };
    }

    private DefaultMcpSession.RequestHandler promptsListRequestHandler() {
        return params -> {
            McpSchema.PaginatedRequest request = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.PaginatedRequest>(){});
            List<McpSchema.Prompt> promptList = this.prompts.values().stream().map(McpServer.PromptRegistration::propmpt).toList();
            return Mono.just((Object)new McpSchema.ListPromptsResult(promptList, null));
        };
    }

    private DefaultMcpSession.RequestHandler promptsGetRequestHandler() {
        return params -> {
            McpSchema.GetPromptRequest request = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.GetPromptRequest>(){});
            if (this.prompts.containsKey(request.name())) {
                return Mono.just((Object)this.prompts.get(request.name()).promptHandler().apply(request));
            }
            return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + request.name())));
        };
    }

    public Mono<Void> notifyToolsListChanged() {
        return this.mcpSession.sendNotification("notifications/tools/list_changed", null);
    }

    public Mono<Void> notifyResourcesListChanged() {
        return this.mcpSession.sendNotification("notifications/resources/list_changed", null);
    }

    public Mono<Void> notifyPromptsListChanged() {
        return this.mcpSession.sendNotification("notifications/prompts/list_changed", null);
    }

    public Mono<Void> closeGracefully() {
        return this.mcpSession.closeGracefully();
    }

    public void close() {
        this.mcpSession.close();
    }
}

