/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.ai.mcp.server.McpAsyncServer;
import org.springframework.ai.mcp.server.McpSyncServer;
import org.springframework.ai.mcp.spec.McpSchema;
import org.springframework.ai.mcp.spec.McpTransport;
import org.springframework.ai.mcp.util.Assert;

public interface McpServer {
    public static Builder using(McpTransport transport) {
        return new Builder(transport);
    }

    public static class Builder {
        private final McpTransport transport;
        private McpSchema.Implementation serverInfo;
        private McpSchema.ServerCapabilities serverCapabilities;
        private final List<ToolRegistration> tools = new ArrayList<ToolRegistration>();
        private Map<String, ResourceRegistration> resources = new HashMap<String, ResourceRegistration>();
        private List<McpSchema.ResourceTemplate> resourceTemplates = new ArrayList<McpSchema.ResourceTemplate>();
        private Map<String, PromptRegistration> prompts = new HashMap<String, PromptRegistration>();

        private Builder(McpTransport transport) {
            Assert.notNull(transport, "Transport must not be null");
            this.transport = transport;
        }

        public Builder info(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public Builder info(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public Builder capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public Builder tool(McpSchema.Tool tool, Function<Map<String, Object>, McpSchema.CallToolResult> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new ToolRegistration(tool, handler));
            return this;
        }

        public Builder tools(List<ToolRegistration> toolRegistrations) {
            Assert.notNull(toolRegistrations, "Tool handlers list must not be null");
            this.tools.addAll(toolRegistrations);
            return this;
        }

        public Builder tools(ToolRegistration ... toolRegistrations) {
            for (ToolRegistration tool : toolRegistrations) {
                this.tools.add(tool);
            }
            return this;
        }

        public Builder resources(Map<String, ResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers map must not be null");
            this.resources.putAll(resourceRegsitrations);
            return this;
        }

        public Builder resources(List<ResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers list must not be null");
            for (ResourceRegistration resource : resourceRegsitrations) {
                this.resources.put(resource.resource().name(), resource);
            }
            return this;
        }

        public Builder resources(ResourceRegistration ... resourceRegistrations) {
            Assert.notNull(resourceRegistrations, "Resource handlers list must not be null");
            for (ResourceRegistration resource : resourceRegistrations) {
                this.resources.put(resource.resource().name(), resource);
            }
            return this;
        }

        public Builder resourceTemplates(List<McpSchema.ResourceTemplate> resourceTemplates) {
            this.resourceTemplates = resourceTemplates;
            return this;
        }

        public Builder resourceTemplates(McpSchema.ResourceTemplate ... resourceTemplates) {
            for (McpSchema.ResourceTemplate resourceTemplate : resourceTemplates) {
                this.resourceTemplates.add(resourceTemplate);
            }
            return this;
        }

        public Builder prompts(Map<String, PromptRegistration> prompts) {
            this.prompts.putAll(prompts);
            return this;
        }

        public Builder prompts(List<PromptRegistration> prompts) {
            for (PromptRegistration prompt : prompts) {
                this.prompts.put(prompt.propmpt().name(), prompt);
            }
            return this;
        }

        public Builder prompts(PromptRegistration ... prompts) {
            for (PromptRegistration prompt : prompts) {
                this.prompts.put(prompt.propmpt().name(), prompt);
            }
            return this;
        }

        public McpSyncServer sync() {
            return new McpSyncServer(this.async());
        }

        public McpAsyncServer async() {
            if (this.serverInfo == null) {
                this.serverInfo = new McpSchema.Implementation("mcp-server", "1.0.0");
            }
            return new McpAsyncServer(this.transport, this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts);
        }
    }

    public record PromptRegistration(McpSchema.Prompt propmpt, Function<McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
    }

    public record ResourceRegistration(McpSchema.Resource resource, Function<McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
    }

    public record ToolRegistration(McpSchema.Tool tool, Function<Map<String, Object>, McpSchema.CallToolResult> call) {
    }
}

