/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config;

import flex.messaging.config.ApacheXPathServerConfigurationParser;
import flex.messaging.config.ConfigurationFileResolver;
import flex.messaging.config.ConfigurationManager;
import flex.messaging.config.ConfigurationParser;
import flex.messaging.config.MessagingConfiguration;
import flex.messaging.config.ServicesConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.JdkVersion;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FlexConfigurationManager
implements ConfigurationManager,
ResourceLoaderAware {
    private static final Log log = LogFactory.getLog(FlexConfigurationManager.class);
    public static final String DEFAULT_CONFIG_PATH = "/WEB-INF/flex/services-config.xml";
    private ResourceLoader resourceLoader;
    private String configurationPath;
    private ConfigurationParser parser = null;

    public FlexConfigurationManager() {
        this.configurationPath = DEFAULT_CONFIG_PATH;
    }

    public FlexConfigurationManager(ResourceLoader resourceLoader, String configurationPath) {
        this.resourceLoader = resourceLoader;
        this.configurationPath = StringUtils.hasText((String)configurationPath) ? configurationPath : DEFAULT_CONFIG_PATH;
    }

    public MessagingConfiguration getMessagingConfiguration(ServletConfig servletConfig) {
        Assert.isTrue((boolean)JdkVersion.isAtLeastJava15(), (String)"Spring BlazeDS Integration requires a minimum of Java 1.5");
        Assert.notNull((Object)servletConfig, (String)"FlexConfigurationManager requires a non-null ServletConfig - Is it being used outside a WebApplicationContext?");
        MessagingConfiguration configuration = new MessagingConfiguration();
        configuration.getSecuritySettings().setServerInfo(servletConfig.getServletContext().getServerInfo());
        if (this.parser == null) {
            this.parser = this.getDefaultConfigurationParser();
        }
        Assert.notNull((Object)this.parser, (String)"Unable to create a parser to load Flex messaging configuration.");
        this.parser.parse(this.configurationPath, (ConfigurationFileResolver)new ResourceResolverAdapter(this.resourceLoader), (ServicesConfiguration)configuration);
        return configuration;
    }

    public void reportTokens() {
        this.parser.reportTokens();
    }

    public void setConfigurationParser(ConfigurationParser parser) {
        this.parser = parser;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private ConfigurationParser getDefaultConfigurationParser() {
        return new ApacheXPathServerConfigurationParser();
    }

    private static class ResourceResolverAdapter
    implements ConfigurationFileResolver {
        private final Stack<Resource> configurationPathStack = new Stack();
        private final ResourceLoader resourceLoader;

        public ResourceResolverAdapter(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        public InputStream getConfigurationFile(String path) {
            try {
                Resource resource = this.resourceLoader.getResource(path);
                if (resource.exists()) {
                    this.pushConfigurationFile(resource);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Loading Flex services configuration from: " + resource.toString()));
                    }
                    return resource.getInputStream();
                }
                throw new IllegalStateException("Flex configuration file does not exist at path: " + path);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Flex configuration file could not be loaded from path: " + path);
            }
        }

        public InputStream getIncludedFile(String relativePath) {
            Resource parent = this.configurationPathStack.peek();
            try {
                Resource resource = parent.createRelative(relativePath);
                if (resource.exists()) {
                    this.pushConfigurationFile(resource);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Including Flex services configuration from: " + resource.toString()));
                    }
                    return resource.getInputStream();
                }
                throw new IllegalStateException("Included Flex configuration file does not exist at relative path: " + relativePath);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Included Flex configuration file could not be loaded from path: " + relativePath);
            }
        }

        public void popIncludedFile() {
            this.configurationPathStack.pop();
        }

        private void pushConfigurationFile(Resource configFile) {
            this.configurationPathStack.push(configFile);
        }
    }
}

