/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.flex.security.FlexSessionInvalidatingAuthenticationListener;
import org.springframework.flex.security.SpringSecurityLoginCommand;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.web.filter.RequestContextFilter;

public class SessionFixationProtectionConfigurer
implements BeanFactoryPostProcessor {
    private static final Log log = LogFactory.getLog(SessionFixationProtectionConfigurer.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory.getBeanNamesForType(SpringSecurityLoginCommand.class).length > 0 && beanFactory.containsBean("_sessionFixationProtectionFilter")) {
            ManagedList filters;
            beanFactory.registerSingleton("_flexSessionAuthenticationListener", (Object)new FlexSessionInvalidatingAuthenticationListener());
            RootBeanDefinition filterList = null;
            if (!beanFactory.containsBean("_filterChainList")) {
                log.warn((Object)"Spring Security filter chain could not be auto-detected.  You must install the RequestContextFilter or RequestContextListenermanually in order for the flex session fixation protection integration to function as expected.");
                return;
            }
            filterList = (RootBeanDefinition)beanFactory.getMergedBeanDefinition("_filterChainList");
            beanFactory.registerSingleton("_requestContextFilter", (Object)new PriorityOrderedRequestContextFilter());
            MutablePropertyValues pvs = filterList.getPropertyValues();
            if (pvs.contains("filters")) {
                filters = (ManagedList)pvs.getPropertyValue("filters").getValue();
            } else {
                filters = new ManagedList();
                pvs.addPropertyValue("filters", (Object)filters);
            }
            filters.add((Object)new RuntimeBeanReference("_requestContextFilter"));
        }
    }

    public static final class PriorityOrderedRequestContextFilter
    extends RequestContextFilter
    implements Ordered {
        private static final int order = FilterChainOrder.getOrder((String)"FIRST");

        public int getOrder() {
            return order;
        }
    }
}

