/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONArray;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkDiscoverer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JsonPathLinkDiscoverer
implements LinkDiscoverer {
    private final String pathTemplate;

    public JsonPathLinkDiscoverer(String pathTemplate) {
        Assert.hasText((String)pathTemplate, (String)"Path template must not be null!");
        Assert.isTrue((StringUtils.countOccurrencesOf((String)pathTemplate, (String)"%s") == 1 ? 1 : 0) != 0, (String)"Path template must contain a single placeholder!");
        this.pathTemplate = pathTemplate;
    }

    @Override
    public Link findLinkWithRel(String rel, String representation) {
        List<Link> links = this.findLinksWithRel(rel, representation);
        return links.isEmpty() ? null : links.get(0);
    }

    @Override
    public Link findLinkWithRel(String rel, InputStream representation) {
        List<Link> links = this.findLinksWithRel(rel, representation);
        return links.isEmpty() ? null : links.get(0);
    }

    @Override
    public List<Link> findLinksWithRel(String rel, String representation) {
        Object parseResult = this.getExpression(rel).read(representation);
        return this.createLinksFrom(parseResult, rel);
    }

    @Override
    public List<Link> findLinksWithRel(String rel, InputStream representation) {
        try {
            Object parseResult = this.getExpression(rel).read(representation);
            return this.createLinksFrom(parseResult, rel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonPath getExpression(String rel) {
        return JsonPath.compile((String)String.format(this.pathTemplate, rel), (Filter[])new Filter[0]);
    }

    private List<Link> createLinksFrom(Object parseResult, String rel) {
        if (parseResult instanceof JSONArray) {
            ArrayList<Link> links = new ArrayList<Link>();
            JSONArray array = (JSONArray)parseResult;
            for (Object element : array) {
                links.add(new Link(element.toString(), rel));
            }
            return Collections.unmodifiableList(links);
        }
        Link link = new Link(parseResult.toString(), rel);
        return Collections.unmodifiableList(Arrays.asList(link));
    }
}

