/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.hateoas.UriTemplate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriUtils;

public final class TemplateVariable
implements Serializable,
UriTemplate.Expandable {
    private static final long serialVersionUID = -2731446749851863774L;
    private final String name;
    private final VariableType type;
    private final String description;
    private final Cardinality cardinality;
    private final int limit;

    public TemplateVariable(String name, VariableType type) {
        this(name, type, "");
    }

    public TemplateVariable(String name, VariableType type, String description) {
        this(name, type, description, Cardinality.SINGULAR, -1);
    }

    TemplateVariable(String name, VariableType type, String description, Cardinality cardinality) {
        this(name, type, description, cardinality, -1);
    }

    TemplateVariable(String name, VariableType type, String description, Cardinality cardinality, int limit) {
        Assert.hasText((String)name, (String)"Variable name must not be null or empty!");
        Assert.notNull((Object)((Object)type), (String)"Variable type must not be null!");
        Assert.notNull((Object)description, (String)"Description must not be null!");
        Assert.notNull((Object)((Object)cardinality), (String)"Cardinality must not be null!");
        this.name = name;
        this.type = type;
        this.description = description;
        this.cardinality = cardinality;
        this.limit = limit;
    }

    public static TemplateVariable pathVariable(String variable) {
        return new TemplateVariable(variable, VariableType.PATH_VARIABLE);
    }

    public static TemplateVariable requestParameter(String parameter) {
        return new TemplateVariable(parameter, VariableType.REQUEST_PARAM);
    }

    public static TemplateVariable requestParameterContinued(String parameter) {
        return new TemplateVariable(parameter, VariableType.REQUEST_PARAM_CONTINUED);
    }

    public static TemplateVariable segment(String segment) {
        return new TemplateVariable(segment, VariableType.SEGMENT);
    }

    public static TemplateVariable fragment(String name) {
        return new TemplateVariable(name, VariableType.FRAGMENT);
    }

    public static TemplateVariable reservedString(String name) {
        return new TemplateVariable(name, VariableType.RESERVED_STRING);
    }

    @Deprecated
    public static TemplateVariable compositeParameter(String parameter) {
        return new TemplateVariable(parameter, VariableType.COMPOSITE_PARAM);
    }

    public TemplateVariable composite() {
        return this.isComposite() ? this : new TemplateVariable(this.name, this.type, this.description, Cardinality.COMPOSITE, this.limit);
    }

    public TemplateVariable singular() {
        return this.isSingular() ? this : new TemplateVariable(this.name, this.type, this.description, Cardinality.SINGULAR, this.limit);
    }

    public TemplateVariable limit(int limit) {
        return new TemplateVariable(this.name, this.type, this.description, this.cardinality, limit);
    }

    public boolean isComposite() {
        return this.cardinality.equals((Object)Cardinality.COMPOSITE);
    }

    public boolean isSingular() {
        return this.cardinality.equals((Object)Cardinality.SINGULAR);
    }

    String fakeName() {
        return String.format("{_____%s_____}", this.name);
    }

    public boolean hasDescription() {
        return StringUtils.hasText((String)this.description);
    }

    @Deprecated
    boolean isRequired() {
        return !this.type.isOptional();
    }

    boolean isCombinable(TemplateVariable variable) {
        return this.type.canBeCombinedWith(variable.type);
    }

    boolean isEquivalent(TemplateVariable variable) {
        return this.name.equals(variable.name) && this.isCombinable(variable);
    }

    boolean isRequestParameterVariable() {
        return this.type.equals((Object)VariableType.REQUEST_PARAM) || this.type.equals((Object)VariableType.REQUEST_PARAM_CONTINUED);
    }

    boolean isFragment() {
        return this.type.equals((Object)VariableType.FRAGMENT);
    }

    TemplateVariable withType(VariableType type) {
        return new TemplateVariable(this.name, type, this.description, this.cardinality, this.limit);
    }

    public String toString() {
        return StringUtils.hasText((String)this.description) ? String.format("%s - %s", this.asString(), this.description) : this.asString();
    }

    @Override
    public String asString() {
        return String.format("{%s%s}", this.type.toString(), this.essence());
    }

    String essence() {
        return String.format("%s%s%s", this.name, this.limit != -1 ? ":".concat(String.valueOf(this.limit)) : "", this.isComposite() ? "*" : "");
    }

    public String getName() {
        return this.name;
    }

    public VariableType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String expand(Map<String, ?> parameters) {
        Object value = parameters.get(this.name);
        if (value == null) {
            return null;
        }
        return this.prepareValue(value);
    }

    @Nullable
    String prepareValue(Map<String, ?> parameters) {
        return this.prepareValue(parameters.get(this.name));
    }

    @Nullable
    String prepareValue(@Nullable Object value) {
        String separator;
        if (value == null) {
            return null;
        }
        String string = separator = this.isComposite() ? this.type.combiner : ",";
        if (value instanceof Iterable) {
            Iterable source = (Iterable)value;
            if (!source.iterator().hasNext()) {
                return null;
            }
            return this.handleComposite(StreamSupport.stream(source.spliterator(), false).map(it -> this.prepareElement(it, false)).collect(Collectors.joining(separator)));
        }
        if (value instanceof Map) {
            String keyValueSeparator = this.isComposite() ? "=" : ",";
            return this.handleComposite(((Map)value).entrySet().stream().map(it -> it.getKey().toString().concat(keyValueSeparator).concat(this.prepareElement(it.getValue(), true))).collect(Collectors.joining(separator)));
        }
        return this.handleComposite(this.prepareElement(value, false));
    }

    @Nullable
    private String prepareElement(Object value, boolean forMap) {
        String encoded = this.limitAndEncode(value);
        if (encoded == null) {
            return null;
        }
        switch (this.type) {
            case REQUEST_PARAM: 
            case REQUEST_PARAM_CONTINUED: 
            case PATH_STYLE_PARAMETER: {
                return this.isComposite() && !forMap ? this.name.concat("=").concat(encoded) : encoded;
            }
        }
        return encoded;
    }

    @Nullable
    private String limitAndEncode(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        String source = value.toString();
        if (this.limit != -1 && this.limit < source.length()) {
            source = source.substring(0, this.limit);
        }
        return this.type.encode(source);
    }

    @Nullable
    private String handleComposite(@Nullable String value) {
        if (value == null) {
            return null;
        }
        switch (this.type) {
            case REQUEST_PARAM: 
            case REQUEST_PARAM_CONTINUED: {
                if (this.isComposite()) {
                    return value;
                }
                return this.name.concat("=").concat(value);
            }
            case PATH_STYLE_PARAMETER: {
                if (this.isComposite()) {
                    return value;
                }
                return StringUtils.hasText((String)value) ? this.name.concat("=").concat(value) : this.name;
            }
        }
        return value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateVariable that = (TemplateVariable)o;
        return Objects.equals(this.name, that.name) && this.type == that.type && this.limit == that.limit && this.cardinality == that.cardinality && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.description});
    }

    public static enum Cardinality {
        SINGULAR,
        COMPOSITE;

    }

    public static enum VariableType {
        SIMPLE("", ",", false),
        PATH_VARIABLE("", ",", true),
        RESERVED_STRING("+", ",", true),
        DOT(".", ".", true),
        REQUEST_PARAM("?", "&", true),
        REQUEST_PARAM_CONTINUED("&", "&", true),
        PATH_SEGMENT("/", "/", true),
        SEGMENT("/", "/", true),
        PATH_STYLE_PARAMETER(";", ";", true),
        FRAGMENT("#", ",", true),
        COMPOSITE_PARAM("*", "", true);

        private static final List<VariableType> COMBINABLE_TYPES;
        static final String DEFAULT_SEPARATOR = ",";
        private final String key;
        private final String combiner;
        private final boolean optional;

        private VariableType(String key, String combiner, boolean optional) {
            this.key = key;
            this.combiner = combiner;
            this.optional = optional;
        }

        public String encode(String value) {
            switch (this) {
                case REQUEST_PARAM: 
                case REQUEST_PARAM_CONTINUED: 
                case PATH_STYLE_PARAMETER: 
                case DOT: 
                case SEGMENT: 
                case PATH_SEGMENT: 
                case SIMPLE: {
                    return UriUtils.encode((String)value, (Charset)StandardCharsets.UTF_8);
                }
            }
            return UriUtils.encodePath((String)value, (Charset)StandardCharsets.UTF_8);
        }

        public boolean isOptional() {
            return this.optional;
        }

        String join(Collection<String> values) {
            if (values.isEmpty()) {
                return "";
            }
            String prefix = this.equals((Object)RESERVED_STRING) ? "" : this.key;
            return values.stream().collect(Collectors.joining(this.combiner, prefix, ""));
        }

        boolean canBeCombinedWith(VariableType type) {
            return this.equals((Object)type) || COMBINABLE_TYPES.contains((Object)this) && COMBINABLE_TYPES.contains((Object)type);
        }

        public static VariableType from(String key) {
            return Arrays.stream(VariableType.values()).filter(type -> type.key.equals(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported variable type " + key + "!"));
        }

        public String toString() {
            return this.key;
        }

        static {
            COMBINABLE_TYPES = Arrays.asList(REQUEST_PARAM, REQUEST_PARAM_CONTINUED);
        }
    }
}

