/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.amqp.outbound.AsyncAmqpOutboundGateway;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AmqpOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        boolean async = element.getLocalName().contains("async");
        if (async) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(AsyncAmqpOutboundGateway.class);
            String asyncTemplateRef = element.getAttribute("async-template");
            if (!StringUtils.hasText((String)asyncTemplateRef)) {
                asyncTemplateRef = "asyncRabbitTemplate";
            }
            builder.addConstructorArgReference(asyncTemplateRef);
        } else {
            builder = BeanDefinitionBuilder.genericBeanDefinition(AmqpOutboundEndpoint.class);
            String amqpTemplateRef = element.getAttribute("amqp-template");
            if (!StringUtils.hasText((String)amqpTemplateRef)) {
                amqpTemplateRef = "amqpTemplate";
            }
            builder.addConstructorArgReference(amqpTemplateRef);
            builder.addPropertyValue("expectReply", (Object)true);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"exchange-name", (boolean)true);
        BeanDefinition exchangeNameExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"exchange-name-expression", (Element)element);
        if (exchangeNameExpression != null) {
            builder.addPropertyValue("exchangeNameExpression", (Object)exchangeNameExpression);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"routing-key", (boolean)true);
        BeanDefinition routingKeyExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"routing-key-expression", (Element)element);
        if (routingKeyExpression != null) {
            builder.addPropertyValue("routingKeyExpression", (Object)routingKeyExpression);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"requires-reply");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"default-delivery-mode");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"lazy-connect");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"return-channel");
        BeanDefinition confirmCorrelationExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"confirm-correlation-expression", (Element)element);
        if (confirmCorrelationExpression != null) {
            builder.addPropertyValue("confirmCorrelationExpression", (Object)confirmCorrelationExpression);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"confirm-ack-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"confirm-nack-channel");
        BeanDefinitionBuilder mapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultAmqpHeaderMapper.class);
        mapperBuilder.setFactoryMethod("outboundMapper");
        IntegrationNamespaceUtils.configureHeaderMapper((Element)element, (BeanDefinitionBuilder)builder, (ParserContext)parserContext, (BeanDefinitionBuilder)mapperBuilder, null);
        return builder;
    }
}

