/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.BadClientCredentialsException;
import org.springframework.security.oauth2.common.exceptions.ClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.common.exceptions.UnapprovedClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedAuthorizationException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.approval.DefaultUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.AbstractEndpoint;
import org.springframework.security.oauth2.provider.endpoint.DefaultRedirectResolver;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.security.oauth2.provider.implicit.ImplicitGrantService;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenRequest;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestValidator;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@FrameworkEndpoint
@SessionAttributes(value={"authorizationRequest"})
public class AuthorizationEndpoint
extends AbstractEndpoint {
    private AuthorizationCodeServices authorizationCodeServices = new InMemoryAuthorizationCodeServices();
    private RedirectResolver redirectResolver = new DefaultRedirectResolver();
    private UserApprovalHandler userApprovalHandler = new DefaultUserApprovalHandler();
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private OAuth2RequestValidator oauth2RequestValidator = new DefaultOAuth2RequestValidator();
    private String userApprovalPage = "forward:/oauth/confirm_access";
    private String errorPage = "forward:/oauth/error";
    private Object implicitLock = new Object();

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    @RequestMapping(value={"/oauth/authorize"})
    public ModelAndView authorize(Map<String, Object> model, @RequestParam Map<String, String> parameters, SessionStatus sessionStatus, Principal principal) {
        AuthorizationRequest authorizationRequest = this.getOAuth2RequestFactory().createAuthorizationRequest(parameters);
        Set<String> responseTypes = authorizationRequest.getResponseTypes();
        if (!responseTypes.contains("token") && !responseTypes.contains("code")) {
            throw new UnsupportedResponseTypeException("Unsupported response types: " + responseTypes);
        }
        if (authorizationRequest.getClientId() == null) {
            throw new InvalidClientException("A client id must be provided");
        }
        try {
            if (!(principal instanceof Authentication) || !((Authentication)principal).isAuthenticated()) {
                throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorization can be completed.");
            }
            ClientDetails client = this.getClientDetailsService().loadClientByClientId(authorizationRequest.getClientId());
            String redirectUriParameter = (String)authorizationRequest.getRequestParameters().get("redirect_uri");
            String resolvedRedirect = this.redirectResolver.resolveRedirect(redirectUriParameter, client);
            if (!StringUtils.hasText((String)resolvedRedirect)) {
                throw new RedirectMismatchException("A redirectUri must be either supplied or preconfigured in the ClientDetails");
            }
            authorizationRequest.setRedirectUri(resolvedRedirect);
            this.oauth2RequestValidator.validateScope(authorizationRequest, client);
            authorizationRequest = this.userApprovalHandler.checkForPreApproval(authorizationRequest, (Authentication)principal);
            boolean approved = this.userApprovalHandler.isApproved(authorizationRequest, (Authentication)principal);
            authorizationRequest.setApproved(approved);
            if (authorizationRequest.isApproved()) {
                if (responseTypes.contains("token")) {
                    return this.getImplicitGrantResponse(authorizationRequest);
                }
                if (responseTypes.contains("code")) {
                    return new ModelAndView(this.getAuthorizationCodeResponse(authorizationRequest, (Authentication)principal));
                }
            }
            model.put("authorizationRequest", authorizationRequest);
            return this.getUserApprovalPageResponse(model, authorizationRequest, (Authentication)principal);
        }
        catch (RuntimeException e) {
            sessionStatus.setComplete();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/oauth/authorize"}, method={RequestMethod.POST}, params={"user_oauth_approval"})
    public View approveOrDeny(@RequestParam Map<String, String> approvalParameters, Map<String, ?> model, SessionStatus sessionStatus, Principal principal) {
        if (!(principal instanceof Authentication)) {
            sessionStatus.setComplete();
            throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorizing an access token.");
        }
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)model.get("authorizationRequest");
        if (authorizationRequest == null) {
            sessionStatus.setComplete();
            throw new InvalidRequestException("Cannot approve uninitialized authorization request.");
        }
        try {
            Set<String> responseTypes = authorizationRequest.getResponseTypes();
            authorizationRequest.setApprovalParameters(approvalParameters);
            authorizationRequest = this.userApprovalHandler.updateAfterApproval(authorizationRequest, (Authentication)principal);
            boolean approved = this.userApprovalHandler.isApproved(authorizationRequest, (Authentication)principal);
            authorizationRequest.setApproved(approved);
            if (authorizationRequest.getRedirectUri() == null) {
                sessionStatus.setComplete();
                throw new InvalidRequestException("Cannot approve request when no redirect URI is provided.");
            }
            if (!authorizationRequest.isApproved()) {
                RedirectView redirectView = new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, new UserDeniedAuthorizationException("User denied access"), responseTypes.contains("token")), false, true, false);
                return redirectView;
            }
            if (responseTypes.contains("token")) {
                View view = this.getImplicitGrantResponse(authorizationRequest).getView();
                return view;
            }
            View view = this.getAuthorizationCodeResponse(authorizationRequest, (Authentication)principal);
            return view;
        }
        finally {
            sessionStatus.setComplete();
        }
    }

    private ModelAndView getUserApprovalPageResponse(Map<String, Object> model, AuthorizationRequest authorizationRequest, Authentication principal) {
        this.logger.debug((Object)("Loading user approval page: " + this.userApprovalPage));
        model.putAll(this.userApprovalHandler.getUserApprovalRequest(authorizationRequest, principal));
        return new ModelAndView(this.userApprovalPage, model);
    }

    private ModelAndView getImplicitGrantResponse(AuthorizationRequest authorizationRequest) {
        try {
            TokenRequest tokenRequest = this.getOAuth2RequestFactory().createTokenRequest(authorizationRequest, "implicit");
            OAuth2Request storedOAuth2Request = this.getOAuth2RequestFactory().createOAuth2Request(authorizationRequest);
            OAuth2AccessToken accessToken = this.getAccessTokenForImplicitGrant(tokenRequest, storedOAuth2Request);
            if (accessToken == null) {
                throw new UnsupportedResponseTypeException("Unsupported response type: token");
            }
            return new ModelAndView((View)new RedirectView(this.appendAccessToken(authorizationRequest, accessToken), false, true, false));
        }
        catch (OAuth2Exception e) {
            return new ModelAndView((View)new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, e, true), false, true, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OAuth2AccessToken getAccessTokenForImplicitGrant(TokenRequest tokenRequest, OAuth2Request storedOAuth2Request) {
        OAuth2AccessToken accessToken = null;
        Object object = this.implicitLock;
        synchronized (object) {
            accessToken = this.getTokenGranter().grant("implicit", new ImplicitTokenRequest(tokenRequest, storedOAuth2Request));
        }
        return accessToken;
    }

    private View getAuthorizationCodeResponse(AuthorizationRequest authorizationRequest, Authentication authUser) {
        try {
            return new RedirectView(this.getSuccessfulRedirect(authorizationRequest, this.generateCode(authorizationRequest, authUser)), false, true, false);
        }
        catch (OAuth2Exception e) {
            return new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, e, false), false, true, false);
        }
    }

    private String appendAccessToken(AuthorizationRequest authorizationRequest, OAuth2AccessToken accessToken) {
        String originalScope;
        Date expiration;
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        HashMap<String, String> keys = new HashMap<String, String>();
        if (accessToken == null) {
            throw new InvalidRequestException("An implicit grant could not be made");
        }
        vars.put("access_token", accessToken.getValue());
        vars.put("token_type", accessToken.getTokenType());
        String state = authorizationRequest.getState();
        if (state != null) {
            vars.put("state", state);
        }
        if ((expiration = accessToken.getExpiration()) != null) {
            long expires_in = (expiration.getTime() - System.currentTimeMillis()) / 1000L;
            vars.put("expires_in", expires_in);
        }
        if ((originalScope = (String)authorizationRequest.getRequestParameters().get("scope")) == null || !OAuth2Utils.parseParameterList(originalScope).equals(accessToken.getScope())) {
            vars.put("scope", OAuth2Utils.formatParameterList(accessToken.getScope()));
        }
        Map<String, Object> additionalInformation = accessToken.getAdditionalInformation();
        for (String key : additionalInformation.keySet()) {
            Object value = additionalInformation.get(key);
            if (value == null) continue;
            keys.put("extra_" + key, key);
            vars.put("extra_" + key, value);
        }
        return this.append(authorizationRequest.getRedirectUri(), vars, keys, true);
    }

    private String generateCode(AuthorizationRequest authorizationRequest, Authentication authentication) throws AuthenticationException {
        try {
            OAuth2Request storedOAuth2Request = this.getOAuth2RequestFactory().createOAuth2Request(authorizationRequest);
            OAuth2Authentication combinedAuth = new OAuth2Authentication(storedOAuth2Request, authentication);
            String code = this.authorizationCodeServices.createAuthorizationCode(combinedAuth);
            return code;
        }
        catch (OAuth2Exception e) {
            if (authorizationRequest.getState() != null) {
                e.addAdditionalInformation("state", authorizationRequest.getState());
            }
            throw e;
        }
    }

    private String getSuccessfulRedirect(AuthorizationRequest authorizationRequest, String authorizationCode) {
        if (authorizationCode == null) {
            throw new IllegalStateException("No authorization code found in the current request scope.");
        }
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("code", authorizationCode);
        String state = authorizationRequest.getState();
        if (state != null) {
            query.put("state", state);
        }
        return this.append(authorizationRequest.getRedirectUri(), query, false);
    }

    private String getUnsuccessfulRedirect(AuthorizationRequest authorizationRequest, OAuth2Exception failure, boolean fragment) {
        if (authorizationRequest == null || authorizationRequest.getRedirectUri() == null) {
            throw new UnapprovedClientAuthenticationException("Authorization failure, and no redirect URI.", failure);
        }
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("error", failure.getOAuth2ErrorCode());
        query.put("error_description", failure.getMessage());
        if (authorizationRequest.getState() != null) {
            query.put("state", authorizationRequest.getState());
        }
        if (failure.getAdditionalInformation() != null) {
            for (Map.Entry<String, String> additionalInfo : failure.getAdditionalInformation().entrySet()) {
                query.put(additionalInfo.getKey(), additionalInfo.getValue());
            }
        }
        return this.append(authorizationRequest.getRedirectUri(), query, fragment);
    }

    private String append(String base, Map<String, ?> query, boolean fragment) {
        return this.append(base, query, null, fragment);
    }

    private String append(String base, Map<String, ?> query, Map<String, String> keys, boolean fragment) {
        URI redirectUri;
        UriComponentsBuilder template = UriComponentsBuilder.newInstance();
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)base);
        try {
            redirectUri = builder.build(true).toUri();
        }
        catch (Exception e) {
            redirectUri = builder.build().toUri();
            builder = UriComponentsBuilder.fromUri((URI)redirectUri);
        }
        template.scheme(redirectUri.getScheme()).port(redirectUri.getPort()).host(redirectUri.getHost()).userInfo(redirectUri.getUserInfo()).path(redirectUri.getPath());
        if (fragment) {
            StringBuilder values = new StringBuilder();
            if (redirectUri.getFragment() != null) {
                String append = redirectUri.getFragment();
                values.append(append);
            }
            for (String key : query.keySet()) {
                if (values.length() > 0) {
                    values.append("&");
                }
                String name = key;
                if (keys != null && keys.containsKey(key)) {
                    name = keys.get(key);
                }
                values.append(name + "={" + key + "}");
            }
            if (values.length() > 0) {
                template.fragment(values.toString());
            }
            UriComponents encoded = template.build().expand(query).encode();
            builder.fragment(encoded.getFragment());
        } else {
            Iterator<String> values = query.keySet().iterator();
            while (values.hasNext()) {
                String key;
                String name = key = values.next();
                if (keys != null && keys.containsKey(key)) {
                    name = keys.get(key);
                }
                template.queryParam(name, new Object[]{"{" + key + "}"});
            }
            template.fragment(redirectUri.getFragment());
            UriComponents encoded = template.build().expand(query).encode();
            builder.query(encoded.getQuery());
        }
        return builder.build().toUriString();
    }

    public void setUserApprovalPage(String userApprovalPage) {
        this.userApprovalPage = userApprovalPage;
    }

    public void setAuthorizationCodeServices(AuthorizationCodeServices authorizationCodeServices) {
        this.authorizationCodeServices = authorizationCodeServices;
    }

    public void setRedirectResolver(RedirectResolver redirectResolver) {
        this.redirectResolver = redirectResolver;
    }

    public void setUserApprovalHandler(UserApprovalHandler userApprovalHandler) {
        this.userApprovalHandler = userApprovalHandler;
    }

    public void setOAuth2RequestValidator(OAuth2RequestValidator oauth2RequestValidator) {
        this.oauth2RequestValidator = oauth2RequestValidator;
    }

    public void setImplicitGrantService(ImplicitGrantService implicitGrantService) {
    }

    @ExceptionHandler(value={ClientRegistrationException.class})
    public ModelAndView handleClientRegistrationException(Exception e, ServletWebRequest webRequest) throws Exception {
        this.logger.info((Object)("Handling ClientRegistrationException error: " + e.getMessage()));
        return this.handleException(new BadClientCredentialsException(), webRequest);
    }

    @ExceptionHandler(value={OAuth2Exception.class})
    public ModelAndView handleOAuth2Exception(OAuth2Exception e, ServletWebRequest webRequest) throws Exception {
        this.logger.info((Object)("Handling OAuth2 error: " + e.getSummary()));
        return this.handleException(e, webRequest);
    }

    @ExceptionHandler(value={HttpSessionRequiredException.class})
    public ModelAndView handleHttpSessionRequiredException(HttpSessionRequiredException e, ServletWebRequest webRequest) throws Exception {
        this.logger.info((Object)("Handling Session required error: " + e.getMessage()));
        return this.handleException((Exception)new AccessDeniedException("Could not obtain authorization request from session", (Throwable)e), webRequest);
    }

    private ModelAndView handleException(Exception e, ServletWebRequest webRequest) throws Exception {
        ResponseEntity<OAuth2Exception> translate = this.getExceptionTranslator().translate(e);
        webRequest.getResponse().setStatus(translate.getStatusCode().value());
        if (e instanceof ClientAuthenticationException || e instanceof RedirectMismatchException) {
            return new ModelAndView(this.errorPage, Collections.singletonMap("error", translate.getBody()));
        }
        AuthorizationRequest authorizationRequest = null;
        try {
            authorizationRequest = this.getAuthorizationRequestForError(webRequest);
            String requestedRedirectParam = (String)authorizationRequest.getRequestParameters().get("redirect_uri");
            String requestedRedirect = this.redirectResolver.resolveRedirect(requestedRedirectParam, this.getClientDetailsService().loadClientByClientId(authorizationRequest.getClientId()));
            authorizationRequest.setRedirectUri(requestedRedirect);
            String redirect = this.getUnsuccessfulRedirect(authorizationRequest, (OAuth2Exception)translate.getBody(), authorizationRequest.getResponseTypes().contains("token"));
            return new ModelAndView((View)new RedirectView(redirect, false, true, false));
        }
        catch (OAuth2Exception ex) {
            return new ModelAndView(this.errorPage, Collections.singletonMap("error", translate.getBody()));
        }
    }

    private AuthorizationRequest getAuthorizationRequestForError(ServletWebRequest webRequest) {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)this.sessionAttributeStore.retrieveAttribute((WebRequest)webRequest, "authorizationRequest");
        if (authorizationRequest != null) {
            return authorizationRequest;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map map = webRequest.getParameterMap();
        for (String key : map.keySet()) {
            String[] values = (String[])map.get(key);
            if (values == null || values.length <= 0) continue;
            parameters.put(key, values[0]);
        }
        try {
            return this.getOAuth2RequestFactory().createAuthorizationRequest(parameters);
        }
        catch (Exception e) {
            return this.getDefaultOAuth2RequestFactory().createAuthorizationRequest(parameters);
        }
    }
}

