/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.jwk;

import java.util.Map;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.util.JsonParser;
import org.springframework.security.oauth2.common.util.JsonParserFactory;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkDefinition;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkDefinitionSource;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkException;
import org.springframework.security.oauth2.provider.token.store.jwk.JwtHeaderConverter;

class JwkVerifyingJwtAccessTokenConverter
extends JwtAccessTokenConverter {
    private final JwkDefinitionSource jwkDefinitionSource;
    private final JwtHeaderConverter jwtHeaderConverter = new JwtHeaderConverter();
    private final JsonParser jsonParser = JsonParserFactory.create();

    JwkVerifyingJwtAccessTokenConverter(JwkDefinitionSource jwkDefinitionSource) {
        this.jwkDefinitionSource = jwkDefinitionSource;
    }

    @Override
    protected Map<String, Object> decode(String token) {
        Jwt jwt;
        Map<String, String> headers = this.jwtHeaderConverter.convert(token);
        String keyIdHeader = headers.get("kid");
        String x5tHeader = headers.get("x5t");
        if (keyIdHeader == null && x5tHeader == null) {
            throw new InvalidTokenException("Invalid JWT/JWS: kid or x5t is a required JOSE Header");
        }
        JwkDefinitionSource.JwkDefinitionHolder jwkDefinitionHolder = this.jwkDefinitionSource.getDefinitionLoadIfNecessary(keyIdHeader, x5tHeader);
        if (jwkDefinitionHolder == null) {
            throw new InvalidTokenException("Invalid JOSE Header kid (" + keyIdHeader + "), " + "x5t" + " (" + x5tHeader + ")");
        }
        JwkDefinition jwkDefinition = jwkDefinitionHolder.getJwkDefinition();
        String algorithmHeader = headers.get("alg");
        if (algorithmHeader == null) {
            throw new InvalidTokenException("Invalid JWT/JWS: alg is a required JOSE Header");
        }
        if (jwkDefinition.getAlgorithm() != null && !algorithmHeader.equals(jwkDefinition.getAlgorithm().headerParamValue())) {
            throw new InvalidTokenException("Invalid JOSE Header alg (" + algorithmHeader + ")" + " does not match algorithm associated to JWK with " + "kid" + " (" + keyIdHeader + "), " + "x5t" + " (" + x5tHeader + ")");
        }
        SignatureVerifier verifier = jwkDefinitionHolder.getSignatureVerifier();
        try {
            jwt = JwtHelper.decode((String)token);
            jwt.verifySignature(verifier);
        }
        catch (Exception ex) {
            throw new InvalidTokenException("Failed to decode/verify JWT/JWS", ex);
        }
        Map<String, Object> claims = this.jsonParser.parseMap(jwt.getClaims());
        if (claims.containsKey("exp") && claims.get("exp") instanceof Integer) {
            Integer expiryInt = (Integer)claims.get("exp");
            claims.put("exp", new Long(expiryInt.intValue()));
        }
        this.getJwtClaimsSetVerifier().verify(claims);
        return claims;
    }

    @Override
    protected String encode(OAuth2AccessToken accessToken, OAuth2Authentication authentication) {
        throw new JwkException("JWT signing (JWS) is not supported.");
    }
}

