/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import org.springframework.util.Assert;

public abstract class AclFormattingUtils {
    public static String demergePatterns(String original, String removeBits) {
        Assert.notNull((Object)original, (String)"Original string required");
        Assert.notNull((Object)removeBits, (String)"Bits To Remove string required");
        Assert.isTrue((original.length() == removeBits.length() ? 1 : 0) != 0, (String)"Original and Bits To Remove strings must be identical length");
        char[] replacement = new char[original.length()];
        for (int i = 0; i < original.length(); ++i) {
            replacement[i] = removeBits.charAt(i) == '.' ? original.charAt(i) : (char)46;
        }
        return new String(replacement);
    }

    public static String mergePatterns(String original, String extraBits) {
        Assert.notNull((Object)original, (String)"Original string required");
        Assert.notNull((Object)extraBits, (String)"Extra Bits string required");
        Assert.isTrue((original.length() == extraBits.length() ? 1 : 0) != 0, (String)"Original and Extra Bits strings must be identical length");
        char[] replacement = new char[extraBits.length()];
        for (int i = 0; i < extraBits.length(); ++i) {
            replacement[i] = extraBits.charAt(i) == '.' ? original.charAt(i) : extraBits.charAt(i);
        }
        return new String(replacement);
    }

    public static String printBinary(int i) {
        return AclFormattingUtils.printBinary(i, '*', '.');
    }

    public static String printBinary(int mask, char code) {
        Assert.doesNotContain((String)Character.toString(code), (String)Character.toString('~'), (String)"~ is a reserved character code");
        Assert.doesNotContain((String)Character.toString(code), (String)Character.toString('.'), (String)". is a reserved character code");
        return AclFormattingUtils.printBinary(mask, '~', '.').replace('~', code);
    }

    private static String printBinary(int i, char on, char off) {
        String s = Integer.toString(i, 2);
        String pattern = "................................";
        String temp2 = pattern.substring(0, pattern.length() - s.length()) + s;
        return temp2.replace('0', off).replace('1', on);
    }
}

