/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

final class LdapEncoder {
    private static final String[] NAME_ESCAPE_TABLE = new String[96];

    private LdapEncoder() {
    }

    static String toTwoCharHex(char c) {
        String raw = Integer.toHexString(c).toUpperCase();
        return raw.length() > 1 ? raw : "0" + raw;
    }

    static String nameEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder encodedValue = new StringBuilder(value.length() * 2);
        int length = value.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            String esc;
            char c = value.charAt(i);
            if (c == ' ' && (i == 0 || i == last)) {
                encodedValue.append("\\ ");
                continue;
            }
            if (c < NAME_ESCAPE_TABLE.length && (esc = NAME_ESCAPE_TABLE[c]) != null) {
                encodedValue.append(esc);
                continue;
            }
            encodedValue.append(c);
        }
        return encodedValue.toString();
    }

    static {
        for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            LdapEncoder.NAME_ESCAPE_TABLE[c] = "\\" + LdapEncoder.toTwoCharHex(c);
        }
        LdapEncoder.NAME_ESCAPE_TABLE[35] = "\\#";
        LdapEncoder.NAME_ESCAPE_TABLE[44] = "\\,";
        LdapEncoder.NAME_ESCAPE_TABLE[59] = "\\;";
        LdapEncoder.NAME_ESCAPE_TABLE[61] = "\\=";
        LdapEncoder.NAME_ESCAPE_TABLE[43] = "\\+";
        LdapEncoder.NAME_ESCAPE_TABLE[60] = "\\<";
        LdapEncoder.NAME_ESCAPE_TABLE[62] = "\\>";
        LdapEncoder.NAME_ESCAPE_TABLE[34] = "\\\"";
        LdapEncoder.NAME_ESCAPE_TABLE[92] = "\\\\";
    }
}

