/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.jdbc.config.annotation.web.http;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.jdbc.JdbcOperationsSessionRepository;
import org.springframework.session.jdbc.config.annotation.web.http.EnableJdbcHttpSession;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@EnableScheduling
public class JdbcHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements ImportAware {
    private String tableName = "";
    private Integer maxInactiveIntervalInSeconds = 1800;
    private LobHandler lobHandler;
    @Autowired(required=false)
    @Qualifier(value="conversionService")
    private ConversionService conversionService;
    private ConversionService springSessionConversionService;

    @Bean
    public JdbcTemplate springSessionJdbcOperations(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean
    public JdbcOperationsSessionRepository sessionRepository(@Qualifier(value="springSessionJdbcOperations") JdbcOperations jdbcOperations, PlatformTransactionManager transactionManager) {
        JdbcOperationsSessionRepository sessionRepository = new JdbcOperationsSessionRepository(jdbcOperations, transactionManager);
        String tableName = this.getTableName();
        if (StringUtils.hasText((String)tableName)) {
            sessionRepository.setTableName(tableName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        if (this.lobHandler != null) {
            sessionRepository.setLobHandler(this.lobHandler);
        }
        if (this.springSessionConversionService != null) {
            sessionRepository.setConversionService(this.springSessionConversionService);
        } else if (this.conversionService != null) {
            sessionRepository.setConversionService(this.conversionService);
        }
        return sessionRepository;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionLobHandler")
    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionConversionService")
    public void setSpringSessionConversionService(ConversionService conversionService) {
        this.springSessionConversionService = conversionService;
    }

    private String getTableName() {
        if (StringUtils.hasText((String)this.tableName)) {
            return this.tableName;
        }
        return System.getProperty("spring.session.jdbc.tableName", "");
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableAttrMap = importMetadata.getAnnotationAttributes(EnableJdbcHttpSession.class.getName());
        AnnotationAttributes enableAttrs = AnnotationAttributes.fromMap((Map)enableAttrMap);
        this.tableName = enableAttrs.getString("tableName");
        this.maxInactiveIntervalInSeconds = (Integer)enableAttrs.getNumber("maxInactiveIntervalInSeconds");
    }
}

