/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.autoproxy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aspectj.util.PartialOrder;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.AbstractAspectJAdvice;
import org.springframework.aop.aspectj.AspectJProxyUtils;
import org.springframework.aop.aspectj.autoproxy.AspectJPrecedenceAwareOrderComparator;
import org.springframework.aop.framework.autoproxy.AbstractAdvisorAutoProxyCreator;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.core.Ordered;

public class AspectJInvocationContextExposingAdvisorAutoProxyCreator
extends AbstractAdvisorAutoProxyCreator {
    protected void extendCandidateAdvisors(List candidateAdvisors) {
        AspectJProxyUtils.makeAdvisorChainAspectJCapableIfNecessary(candidateAdvisors);
    }

    protected List sortAdvisors(List advisors) {
        if (advisors == null || advisors.isEmpty()) {
            return advisors;
        }
        boolean hasExposeInvocationInterceptor = this.excludeExposeInvocationInterceptorFromSorting(advisors);
        List ordered = this.sortRemainingAdvisors(advisors);
        if (hasExposeInvocationInterceptor) {
            ordered.add(0, ExposeInvocationInterceptor.ADVISOR);
        }
        return ordered;
    }

    private List sortRemainingAdvisors(List advisors) {
        AspectJPrecedenceAwareOrderComparator comparator = new AspectJPrecedenceAwareOrderComparator();
        ArrayList<PartiallyComparableAdvisor> partiallyComparableAdvisors = new ArrayList<PartiallyComparableAdvisor>();
        Iterator iter = advisors.iterator();
        while (iter.hasNext()) {
            Advisor element = (Advisor)iter.next();
            PartiallyComparableAdvisor advisor = new PartiallyComparableAdvisor(element, comparator);
            partiallyComparableAdvisors.add(advisor);
        }
        List sorted = PartialOrder.sort(partiallyComparableAdvisors);
        if (sorted == null) {
            throw new IllegalArgumentException("Advice precedence circularity error");
        }
        LinkedList<Advisor> result = new LinkedList<Advisor>();
        Iterator iter2 = sorted.iterator();
        while (iter2.hasNext()) {
            PartiallyComparableAdvisor pcAdvisor = (PartiallyComparableAdvisor)iter2.next();
            result.add(pcAdvisor.getAdvisor());
        }
        return result;
    }

    private boolean excludeExposeInvocationInterceptorFromSorting(List advisors) {
        if (advisors.get(0) == ExposeInvocationInterceptor.ADVISOR) {
            advisors.remove(0);
            return true;
        }
        return false;
    }

    private static class PartiallyComparableAdvisor
    implements PartialOrder.PartialComparable {
        private final Advisor advisor;
        private final Comparator comparator;

        public PartiallyComparableAdvisor(Advisor advisor, AspectJPrecedenceAwareOrderComparator comparator) {
            this.advisor = advisor;
            this.comparator = comparator;
        }

        public int compareTo(Object obj) {
            Advisor otherAdvisor = ((PartiallyComparableAdvisor)obj).advisor;
            return this.comparator.compare(this.advisor, otherAdvisor);
        }

        public int fallbackCompareTo(Object obj) {
            return 0;
        }

        public Advisor getAdvisor() {
            return this.advisor;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Advice advice = this.advisor.getAdvice();
            sb.append(advice.getClass().getSimpleName());
            sb.append(":");
            if (this.advisor instanceof Ordered) {
                sb.append("order " + ((Ordered)this.advisor).getOrder() + ", ");
            }
            if (advice instanceof AbstractAspectJAdvice) {
                AbstractAspectJAdvice ajAdvice = (AbstractAspectJAdvice)advice;
                sb.append(ajAdvice.getAspectName());
                sb.append(", declaration order= ");
                sb.append(ajAdvice.getOrder());
            }
            return sb.toString();
        }
    }
}

