/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.generator.BeanDefinitionGenerationException;
import org.springframework.beans.factory.generator.BeanFactoryContribution;
import org.springframework.beans.factory.generator.BeanFactoryInitialization;
import org.springframework.beans.factory.generator.BeanRegistrationContributionNotFoundException;
import org.springframework.beans.factory.generator.BeanRegistrationContributionProvider;
import org.springframework.beans.factory.generator.DefaultBeanRegistrationContributionProvider;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class BeanDefinitionsContribution
implements BeanFactoryContribution {
    private final DefaultListableBeanFactory beanFactory;
    private final List<BeanRegistrationContributionProvider> contributionProviders;
    private final Map<String, BeanFactoryContribution> contributions;

    BeanDefinitionsContribution(DefaultListableBeanFactory beanFactory, List<BeanRegistrationContributionProvider> contributionProviders) {
        this.beanFactory = beanFactory;
        this.contributionProviders = contributionProviders;
        this.contributions = new HashMap<String, BeanFactoryContribution>();
    }

    public BeanDefinitionsContribution(DefaultListableBeanFactory beanFactory) {
        this(beanFactory, BeanDefinitionsContribution.initializeProviders(beanFactory));
    }

    private static List<BeanRegistrationContributionProvider> initializeProviders(DefaultListableBeanFactory beanFactory) {
        ArrayList<BeanRegistrationContributionProvider> providers = new ArrayList<BeanRegistrationContributionProvider>(SpringFactoriesLoader.loadFactories(BeanRegistrationContributionProvider.class, (ClassLoader)beanFactory.getBeanClassLoader()));
        providers.add(new DefaultBeanRegistrationContributionProvider(beanFactory));
        return providers;
    }

    @Override
    public void applyTo(BeanFactoryInitialization initialization) {
        this.writeBeanDefinitions(initialization);
    }

    @Override
    public BiPredicate<String, BeanDefinition> getBeanDefinitionExcludeFilter() {
        ArrayList predicates = new ArrayList();
        for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
            this.handleMergedBeanDefinition(beanName, beanDefinition -> predicates.add(this.getBeanRegistrationContribution(beanName, (RootBeanDefinition)beanDefinition).getBeanDefinitionExcludeFilter()));
        }
        return predicates.stream().filter(Objects::nonNull).reduce((n, d) -> false, BiPredicate::or);
    }

    private void writeBeanDefinitions(BeanFactoryInitialization initialization) {
        for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
            this.handleMergedBeanDefinition(beanName, beanDefinition -> {
                BeanFactoryContribution registrationContribution = this.getBeanRegistrationContribution(beanName, (RootBeanDefinition)beanDefinition);
                registrationContribution.applyTo(initialization);
            });
        }
    }

    private BeanFactoryContribution getBeanRegistrationContribution(String beanName, RootBeanDefinition beanDefinition) {
        return this.contributions.computeIfAbsent(beanName, name -> {
            for (BeanRegistrationContributionProvider provider : this.contributionProviders) {
                BeanFactoryContribution contribution = provider.getContributionFor(beanName, beanDefinition);
                if (contribution == null) continue;
                return contribution;
            }
            throw new BeanRegistrationContributionNotFoundException(beanName, beanDefinition);
        });
    }

    private void handleMergedBeanDefinition(String beanName, Consumer<RootBeanDefinition> consumer) {
        RootBeanDefinition beanDefinition = (RootBeanDefinition)this.beanFactory.getMergedBeanDefinition(beanName);
        try {
            consumer.accept(beanDefinition);
        }
        catch (BeanDefinitionGenerationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = String.format("Failed to handle bean with name '%s' and type '%s'", beanName, beanDefinition.getResolvableType());
            throw new BeanDefinitionGenerationException(beanName, beanDefinition, msg, ex);
        }
    }
}

