/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generator;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generator.GeneratedType;
import org.springframework.aot.generator.GeneratedTypeContext;
import org.springframework.aot.generator.ProtectedAccess;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;

public class BeanFactoryInitialization {
    private final GeneratedTypeContext generatedTypeContext;
    private final CodeBlock.Builder codeContributions;

    public BeanFactoryInitialization(GeneratedTypeContext generatedTypeContext) {
        this.generatedTypeContext = generatedTypeContext;
        this.codeContributions = CodeBlock.builder();
    }

    public GeneratedTypeContext generatedTypeContext() {
        return this.generatedTypeContext;
    }

    public void contribute(Consumer<CodeBlock.Builder> code) {
        CodeBlock.Builder builder = CodeBlock.builder();
        code.accept(builder);
        CodeBlock codeBlock = builder.build();
        this.codeContributions.add(codeBlock);
        if (!codeBlock.toString().endsWith("\n")) {
            this.codeContributions.add("\n", new Object[0]);
        }
    }

    public void contribute(ProtectedAccess protectedAccess, Supplier<String> methodName, Consumer<CodeBlock.Builder> methodBody) {
        String targetPackageName = this.generatedTypeContext.getMainGeneratedType().getClassName().packageName();
        String protectedPackageName = protectedAccess.getPrivilegedPackageName(targetPackageName);
        if (protectedPackageName != null) {
            GeneratedType type = this.generatedTypeContext.getGeneratedType(protectedPackageName);
            MethodSpec.Builder method = MethodSpec.methodBuilder((String)methodName.get()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(DefaultListableBeanFactory.class, "beanFactory", new Modifier[0]);
            CodeBlock.Builder code = CodeBlock.builder();
            methodBody.accept(code);
            method.addCode(code.build());
            this.contribute(main -> main.addStatement("$T.$N(beanFactory)", new Object[]{type.getClassName(), type.addMethod(method)}));
        } else {
            this.contribute(methodBody);
        }
    }

    public CodeBlock toCodeBlock() {
        return this.codeContributions.build();
    }
}

