/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generator;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.aot.generator.ResolvableTypeGenerator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.support.MultiCodeBlock;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public final class BeanParameterGenerator {
    public static final BeanParameterGenerator INSTANCE = new BeanParameterGenerator();
    private final ResolvableTypeGenerator typeGenerator = new ResolvableTypeGenerator();
    private final Function<BeanDefinition, CodeBlock> innerBeanDefinitionGenerator;

    public BeanParameterGenerator(Function<BeanDefinition, CodeBlock> innerBeanDefinitionGenerator) {
        this.innerBeanDefinitionGenerator = innerBeanDefinitionGenerator;
    }

    public BeanParameterGenerator() {
        this(beanDefinition -> {
            throw new IllegalStateException("Inner bean definition is not supported by this instance");
        });
    }

    public CodeBlock generateParameterValue(@Nullable Object value) {
        return this.generateParameterValue(value, () -> ResolvableType.forInstance((Object)value));
    }

    public CodeBlock generateParameterValue(@Nullable Object value, Supplier<ResolvableType> parameterType) {
        CodeBlock.Builder code = CodeBlock.builder();
        this.generateParameterValue(code, value, parameterType);
        return code.build();
    }

    public CodeBlock generateExecutableParameterTypes(Executable executable) {
        Class[] parameterTypes = (Class[])Arrays.stream(executable.getParameters()).map(Parameter::getType).toArray(Class[]::new);
        return CodeBlock.of((String)Arrays.stream(parameterTypes).map(d -> "$T.class").collect(Collectors.joining(", ")), (Object[])parameterTypes);
    }

    private void generateParameterValue(CodeBlock.Builder code, @Nullable Object value, Supplier<ResolvableType> parameterTypeSupplier) {
        if (value == null) {
            code.add("null", new Object[0]);
            return;
        }
        ResolvableType parameterType = parameterTypeSupplier.get();
        if (parameterType.isArray()) {
            code.add("new $T { ", new Object[]{parameterType.toClass()});
            code.add(this.generateAll(Arrays.asList(ObjectUtils.toObjectArray((Object)value)), item -> parameterType.getComponentType()));
            code.add(" }", new Object[0]);
        } else if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                code.add("$T.emptyList()", new Object[]{Collections.class});
            } else {
                Class listType = value instanceof ManagedList ? ManagedList.class : List.class;
                code.add("$T.of(", new Object[]{listType});
                ResolvableType collectionType = parameterType.as(List.class).getGenerics()[0];
                code.add(this.generateAll(list, item -> collectionType));
                code.add(")", new Object[0]);
            }
        } else if (value instanceof Set) {
            Set set = (Set)value;
            if (set.isEmpty()) {
                code.add("$T.emptySet()", new Object[]{Collections.class});
            } else {
                Class setType = value instanceof ManagedSet ? ManagedSet.class : Set.class;
                code.add("$T.of(", new Object[]{setType});
                ResolvableType collectionType = parameterType.as(Set.class).getGenerics()[0];
                code.add(this.generateAll(set, item -> collectionType));
                code.add(")", new Object[0]);
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            if (map.size() <= 10) {
                code.add("$T.of(", new Object[]{Map.class});
                ArrayList parameters = new ArrayList();
                map.forEach((mapKey, mapValue) -> {
                    parameters.add(mapKey);
                    parameters.add(mapValue);
                });
                code.add(this.generateAll(parameters, ResolvableType::forInstance));
                code.add(")", new Object[0]);
            }
        } else if (value instanceof Character) {
            Character character = (Character)value;
            String result = "'" + BeanParameterGenerator.characterLiteralWithoutSingleQuotes(character.charValue()) + "'";
            code.add(result, new Object[0]);
        } else if (this.isPrimitiveOrWrapper(value)) {
            code.add("$L", new Object[]{value});
        } else if (value instanceof String) {
            code.add("$S", new Object[]{value});
        } else if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            code.add("$T.$N", new Object[]{enumValue.getClass(), enumValue.name()});
        } else if (value instanceof Class) {
            code.add("$T.class", new Object[]{value});
        } else if (value instanceof ResolvableType) {
            code.add(this.typeGenerator.generateTypeFor((ResolvableType)value));
        } else if (value instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)value;
            code.add(this.innerBeanDefinitionGenerator.apply(bd));
        } else if (value instanceof BeanReference) {
            code.add("new $T($S)", new Object[]{RuntimeBeanReference.class, ((BeanReference)value).getBeanName()});
        } else {
            throw new IllegalArgumentException("Parameter of type " + parameterType + " is not supported");
        }
    }

    private <T> CodeBlock generateAll(Iterable<T> items, Function<T, ResolvableType> elementType) {
        MultiCodeBlock multi = new MultiCodeBlock();
        items.forEach(item -> multi.add(code -> this.generateParameterValue((CodeBlock.Builder)code, item, () -> (ResolvableType)elementType.apply(item))));
        return multi.join(", ");
    }

    private boolean isPrimitiveOrWrapper(Object value) {
        Class<?> valueType = value.getClass();
        return valueType.isPrimitive() || valueType == Double.class || valueType == Float.class || valueType == Long.class || valueType == Integer.class || valueType == Short.class || valueType == Character.class || valueType == Byte.class || valueType == Boolean.class;
    }

    private static String characterLiteralWithoutSingleQuotes(char c) {
        return switch (c) {
            case '\b' -> "\\b";
            case '\t' -> "\\t";
            case '\n' -> "\\n";
            case '\f' -> "\\f";
            case '\r' -> "\\r";
            case '\"' -> "\"";
            case '\'' -> "\\'";
            case '\\' -> "\\\\";
            default -> Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.toString(c);
        };
    }
}

