/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generator;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.lang.model.SourceVersion;
import org.springframework.aot.generator.CodeContribution;
import org.springframework.aot.generator.ProtectedAccess;
import org.springframework.aot.generator.ResolvableTypeGenerator;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.ExtendedBeanInfoFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.generator.BeanFactoryContribution;
import org.springframework.beans.factory.generator.BeanFactoryInitialization;
import org.springframework.beans.factory.generator.BeanInstantiationGenerator;
import org.springframework.beans.factory.generator.BeanParameterGenerator;
import org.springframework.beans.factory.generator.DefaultBeanRegistrationContributionProvider;
import org.springframework.beans.factory.generator.config.BeanDefinitionRegistrar;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.support.MultiStatement;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BeanRegistrationBeanFactoryContribution
implements BeanFactoryContribution {
    private static final BeanInfoFactory beanInfoFactory = new ExtendedBeanInfoFactory();
    private static final ResolvableTypeGenerator typeGenerator = new ResolvableTypeGenerator();
    private final String beanName;
    private final RootBeanDefinition beanDefinition;
    private final BeanInstantiationGenerator beanInstantiationGenerator;
    @Nullable
    private final DefaultBeanRegistrationContributionProvider innerBeanRegistrationContributionProvider;
    private int nesting = 0;

    BeanRegistrationBeanFactoryContribution(String beanName, RootBeanDefinition beanDefinition, BeanInstantiationGenerator beanInstantiationGenerator, @Nullable DefaultBeanRegistrationContributionProvider innerBeanRegistrationContributionProvider) {
        this.beanName = beanName;
        this.beanDefinition = beanDefinition;
        this.beanInstantiationGenerator = beanInstantiationGenerator;
        this.innerBeanRegistrationContributionProvider = innerBeanRegistrationContributionProvider;
    }

    public BeanRegistrationBeanFactoryContribution(String beanName, RootBeanDefinition beanDefinition, BeanInstantiationGenerator beanInstantiationGenerator) {
        this(beanName, beanDefinition, beanInstantiationGenerator, null);
    }

    String getBeanName() {
        return this.beanName;
    }

    RootBeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }

    @Override
    public void applyTo(BeanFactoryInitialization initialization) {
        RuntimeHints runtimeHints = initialization.generatedTypeContext().runtimeHints();
        this.registerRuntimeHints(runtimeHints);
        CodeContribution beanInstanceContribution = this.generateBeanInstance(runtimeHints);
        ProtectedAccess protectedAccess = beanInstanceContribution.protectedAccess();
        protectedAccess.analyze(this.beanDefinition.getResolvableType());
        initialization.contribute(protectedAccess, this::registerBeanMethodName, code -> code.add(this.generateBeanRegistration(runtimeHints, beanInstanceContribution.statements())));
    }

    void registerRuntimeHints(RuntimeHints runtimeHints) {
        Object[] destroyMethodNames;
        Object[] initMethodNames = this.beanDefinition.getInitMethodNames();
        if (!ObjectUtils.isEmpty((Object[])initMethodNames)) {
            this.registerInitDestroyMethodsRuntimeHints((String[])initMethodNames, runtimeHints);
        }
        if (!ObjectUtils.isEmpty((Object[])(destroyMethodNames = this.beanDefinition.getDestroyMethodNames()))) {
            this.registerInitDestroyMethodsRuntimeHints((String[])destroyMethodNames, runtimeHints);
        }
        this.registerPropertyValuesRuntimeHints(runtimeHints);
    }

    CodeBlock generateBeanRegistration(RuntimeHints runtimeHints, MultiStatement beanInstanceStatements) {
        BeanParameterGenerator parameterGenerator = this.createBeanParameterGenerator(runtimeHints);
        Generator generator = new Generator(parameterGenerator);
        return generator.generateBeanRegistration(beanInstanceStatements);
    }

    CodeBlock generateBeanDefinition(RuntimeHints runtimeHints) {
        CodeContribution beanInstanceContribution = this.generateBeanInstance(runtimeHints);
        BeanParameterGenerator parameterGenerator = this.createBeanParameterGenerator(runtimeHints);
        Generator generator = new Generator(parameterGenerator);
        return generator.generateBeanDefinition(beanInstanceContribution.statements());
    }

    private BeanParameterGenerator createBeanParameterGenerator(RuntimeHints runtimeHints) {
        return new BeanParameterGenerator(beanDefinition -> this.generateInnerBeanDefinition((BeanDefinition)beanDefinition, runtimeHints));
    }

    protected Predicate<String> getAttributeFilter() {
        return candidate -> false;
    }

    protected boolean shouldDeclareCreator(Executable instanceCreator) {
        if (instanceCreator instanceof Method) {
            return true;
        }
        if (instanceCreator instanceof Constructor) {
            Constructor constructor = (Constructor)instanceCreator;
            int minArgs = BeanRegistrationBeanFactoryContribution.isInnerClass(constructor.getDeclaringClass()) ? 2 : 1;
            return instanceCreator.getParameterCount() >= minArgs;
        }
        return false;
    }

    protected CodeContribution generateBeanInstance(RuntimeHints runtimeHints) {
        return this.beanInstantiationGenerator.generateBeanInstantiation(runtimeHints);
    }

    private void registerInitDestroyMethodsRuntimeHints(String[] methodNames, RuntimeHints runtimeHints) {
        for (String methodName : methodNames) {
            Method method = ReflectionUtils.findMethod(this.getUserBeanClass(), (String)methodName);
            if (method == null) continue;
            runtimeHints.reflection().registerMethod(method, hint -> hint.withMode(ExecutableMode.INVOKE));
        }
    }

    private void registerPropertyValuesRuntimeHints(RuntimeHints runtimeHints) {
        if (!this.beanDefinition.hasPropertyValues()) {
            return;
        }
        BeanInfo beanInfo = this.getBeanInfo(this.beanDefinition.getResolvableType().toClass());
        if (beanInfo != null) {
            ReflectionHints reflectionHints = runtimeHints.reflection();
            this.beanDefinition.getPropertyValues().getPropertyValueList().forEach(propertyValue -> {
                Method writeMethod = this.findWriteMethod(beanInfo, propertyValue.getName());
                if (writeMethod != null) {
                    reflectionHints.registerMethod(writeMethod, hint -> hint.withMode(ExecutableMode.INVOKE));
                }
            });
        }
    }

    @Nullable
    private BeanInfo getBeanInfo(Class<?> beanType) {
        try {
            BeanInfo beanInfo = beanInfoFactory.getBeanInfo(beanType);
            if (beanInfo != null) {
                return beanInfo;
            }
            return Introspector.getBeanInfo(beanType, 3);
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    @Nullable
    private Method findWriteMethod(BeanInfo beanInfo, String propertyName) {
        return Arrays.stream(beanInfo.getPropertyDescriptors()).filter(pd -> propertyName.equals(pd.getName())).map(PropertyDescriptor::getWriteMethod).filter(Objects::nonNull).findFirst().orElse(null);
    }

    protected CodeBlock initializeBeanDefinitionRegistrar() {
        return CodeBlock.of((String)"$T.of($S, ", (Object[])new Object[]{BeanDefinitionRegistrar.class, this.beanName});
    }

    private Class<?> getUserBeanClass() {
        return ClassUtils.getUserClass((Class)this.beanDefinition.getResolvableType().toClass());
    }

    private void handleCreatorReference(CodeBlock.Builder code, Executable creator) {
        if (creator instanceof Method) {
            code.add(".withFactoryMethod($T.class, $S", new Object[]{creator.getDeclaringClass(), creator.getName()});
            if (creator.getParameterCount() > 0) {
                code.add(", ", new Object[0]);
            }
        } else {
            code.add(".withConstructor(", new Object[0]);
        }
        code.add(BeanParameterGenerator.INSTANCE.generateExecutableParameterTypes(creator));
        code.add(")", new Object[0]);
    }

    private CodeBlock generateInnerBeanDefinition(BeanDefinition beanDefinition, RuntimeHints runtimeHints) {
        if (this.innerBeanRegistrationContributionProvider == null) {
            throw new IllegalStateException("This generator does not handle inner bean definition " + beanDefinition);
        }
        BeanRegistrationBeanFactoryContribution innerBeanRegistrationContribution = this.innerBeanRegistrationContributionProvider.getInnerBeanRegistrationContribution(this, beanDefinition);
        innerBeanRegistrationContribution.nesting = this.nesting + 1;
        innerBeanRegistrationContribution.registerRuntimeHints(runtimeHints);
        return innerBeanRegistrationContribution.generateBeanDefinition(runtimeHints);
    }

    private String registerBeanMethodName() {
        Executable instanceCreator = this.beanInstantiationGenerator.getInstanceCreator();
        if (instanceCreator instanceof Method) {
            Method method = (Method)instanceCreator;
            String target = this.isValidName(this.beanName) ? this.beanName : method.getName();
            return String.format("register%s_%s", method.getDeclaringClass().getSimpleName(), target);
        }
        if (instanceCreator.getDeclaringClass().getEnclosingClass() != null) {
            String target = this.isValidName(this.beanName) ? this.beanName : this.getUserBeanClass().getSimpleName();
            Class<?> enclosingClass = instanceCreator.getDeclaringClass().getEnclosingClass();
            return String.format("register%s_%s", enclosingClass.getSimpleName(), target);
        }
        String target = this.isValidName(this.beanName) ? this.beanName : this.getUserBeanClass().getSimpleName();
        return "register" + StringUtils.capitalize((String)target);
    }

    private boolean isValidName(@Nullable String name) {
        return name != null && SourceVersion.isIdentifier(name) && !SourceVersion.isKeyword(name);
    }

    private String determineVariableName(String name) {
        return name + "_".repeat(this.nesting);
    }

    private static boolean isInnerClass(Class<?> type) {
        return type.isMemberClass() && !Modifier.isStatic(type.getModifiers());
    }

    class Generator {
        private final BeanParameterGenerator parameterGenerator;
        private final RootBeanDefinition beanDefinition;

        Generator(BeanParameterGenerator parameterGenerator) {
            this.parameterGenerator = parameterGenerator;
            this.beanDefinition = BeanRegistrationBeanFactoryContribution.this.beanDefinition;
        }

        CodeBlock generateBeanRegistration(MultiStatement instanceStatements) {
            CodeBlock.Builder code = CodeBlock.builder();
            this.initializeBeanDefinitionRegistrar(instanceStatements, code);
            code.addStatement(".register(beanFactory)", new Object[0]);
            return code.build();
        }

        CodeBlock generateBeanDefinition(MultiStatement instanceStatements) {
            CodeBlock.Builder code = CodeBlock.builder();
            this.initializeBeanDefinitionRegistrar(instanceStatements, code);
            code.add(".toBeanDefinition()", new Object[0]);
            return code.build();
        }

        private void initializeBeanDefinitionRegistrar(MultiStatement instanceStatements, CodeBlock.Builder code) {
            Executable instanceCreator = BeanRegistrationBeanFactoryContribution.this.beanInstantiationGenerator.getInstanceCreator();
            code.add(BeanRegistrationBeanFactoryContribution.this.initializeBeanDefinitionRegistrar());
            this.generateBeanType(code);
            code.add(")", new Object[0]);
            boolean shouldDeclareCreator = BeanRegistrationBeanFactoryContribution.this.shouldDeclareCreator(instanceCreator);
            if (shouldDeclareCreator) {
                BeanRegistrationBeanFactoryContribution.this.handleCreatorReference(code, instanceCreator);
            }
            code.add("\n", new Object[0]).indent().indent();
            code.add(".instanceSupplier(", new Object[0]);
            code.add(instanceStatements.toCodeBlock());
            code.add(")", new Object[0]).unindent().unindent();
            this.handleBeanDefinitionMetadata(code);
        }

        private void generateBeanType(CodeBlock.Builder code) {
            ResolvableType resolvableType = this.beanDefinition.getResolvableType();
            if (resolvableType.hasGenerics() && !this.hasUnresolvedGenerics(resolvableType)) {
                code.add(typeGenerator.generateTypeFor(resolvableType));
            } else {
                code.add("$T.class", new Object[]{BeanRegistrationBeanFactoryContribution.this.getUserBeanClass()});
            }
        }

        private boolean hasUnresolvedGenerics(ResolvableType resolvableType) {
            if (resolvableType.hasUnresolvableGenerics()) {
                return true;
            }
            for (ResolvableType generic : resolvableType.getGenerics()) {
                if (!this.hasUnresolvedGenerics(generic)) continue;
                return true;
            }
            return false;
        }

        private void handleBeanDefinitionMetadata(CodeBlock.Builder code) {
            Map<Integer, ConstructorArgumentValues.ValueHolder> indexedArgumentValues;
            Object[] dependsOn;
            String scope;
            Object[] destroyMethodNames;
            String bdVariable = BeanRegistrationBeanFactoryContribution.this.determineVariableName("bd");
            MultiStatement statements = new MultiStatement();
            Object[] initMethodNames = this.beanDefinition.getInitMethodNames();
            if (!ObjectUtils.isEmpty((Object[])initMethodNames)) {
                this.handleInitMethodNames(statements, bdVariable, (String[])initMethodNames);
            }
            if (!ObjectUtils.isEmpty((Object[])(destroyMethodNames = this.beanDefinition.getDestroyMethodNames()))) {
                this.handleDestroyMethodNames(statements, bdVariable, (String[])destroyMethodNames);
            }
            if (this.beanDefinition.isPrimary()) {
                statements.addStatement("$L.setPrimary(true)", new Object[]{bdVariable});
            }
            if (StringUtils.hasText((String)(scope = this.beanDefinition.getScope())) && !"singleton".equals(scope)) {
                statements.addStatement("$L.setScope($S)", new Object[]{bdVariable, scope});
            }
            if (!ObjectUtils.isEmpty((Object[])(dependsOn = this.beanDefinition.getDependsOn()))) {
                statements.addStatement("$L.setDependsOn($L)", new Object[]{bdVariable, this.parameterGenerator.generateParameterValue(dependsOn)});
            }
            if (this.beanDefinition.isLazyInit()) {
                statements.addStatement("$L.setLazyInit(true)", new Object[]{bdVariable});
            }
            if (!this.beanDefinition.isAutowireCandidate()) {
                statements.addStatement("$L.setAutowireCandidate(false)", new Object[]{bdVariable});
            }
            if (this.beanDefinition.isSynthetic()) {
                statements.addStatement("$L.setSynthetic(true)", new Object[]{bdVariable});
            }
            if (this.beanDefinition.getRole() != 0) {
                statements.addStatement("$L.setRole($L)", new Object[]{bdVariable, this.beanDefinition.getRole()});
            }
            if (!(indexedArgumentValues = this.beanDefinition.getConstructorArgumentValues().getIndexedArgumentValues()).isEmpty()) {
                this.handleArgumentValues(statements, bdVariable, indexedArgumentValues);
            }
            if (this.beanDefinition.hasPropertyValues()) {
                this.handlePropertyValues(statements, bdVariable, this.beanDefinition.getPropertyValues());
            }
            if (this.beanDefinition.attributeNames().length > 0) {
                this.handleAttributes(statements, bdVariable);
            }
            if (statements.isEmpty()) {
                return;
            }
            code.add(statements.toCodeBlock(".customize((" + bdVariable + ") ->"));
            code.add(")", new Object[0]);
        }

        private void handleInitMethodNames(MultiStatement statements, String bdVariable, String[] initMethodNames) {
            if (initMethodNames.length == 1) {
                statements.addStatement("$L.setInitMethodName($S)", new Object[]{bdVariable, initMethodNames[0]});
            } else {
                statements.addStatement("$L.setInitMethodNames($L)", new Object[]{bdVariable, this.parameterGenerator.generateParameterValue(initMethodNames)});
            }
        }

        private void handleDestroyMethodNames(MultiStatement statements, String bdVariable, String[] destroyMethodNames) {
            if (destroyMethodNames.length == 1) {
                statements.addStatement("$L.setDestroyMethodName($S)", new Object[]{bdVariable, destroyMethodNames[0]});
            } else {
                statements.addStatement("$L.setDestroyMethodNames($L)", new Object[]{bdVariable, this.parameterGenerator.generateParameterValue(destroyMethodNames)});
            }
        }

        private void handleArgumentValues(MultiStatement statements, String bdVariable, Map<Integer, ConstructorArgumentValues.ValueHolder> indexedArgumentValues) {
            if (indexedArgumentValues.size() == 1) {
                Map.Entry<Integer, ConstructorArgumentValues.ValueHolder> entry2 = indexedArgumentValues.entrySet().iterator().next();
                statements.addStatement(this.generateArgumentValue(bdVariable + ".getConstructorArgumentValues().", entry2.getKey(), entry2.getValue()));
            } else {
                String avVariable = BeanRegistrationBeanFactoryContribution.this.determineVariableName("argumentValues");
                statements.addStatement("$T $L = $L.getConstructorArgumentValues()", new Object[]{ConstructorArgumentValues.class, avVariable, bdVariable});
                statements.addAll(indexedArgumentValues.entrySet(), entry -> this.generateArgumentValue(avVariable + ".", (Integer)entry.getKey(), (ConstructorArgumentValues.ValueHolder)entry.getValue()));
            }
        }

        private CodeBlock generateArgumentValue(String prefix, Integer index, ConstructorArgumentValues.ValueHolder valueHolder) {
            CodeBlock.Builder code = CodeBlock.builder();
            code.add(prefix, new Object[0]);
            code.add("addIndexedArgumentValue($L, ", new Object[]{index});
            Object value = valueHolder.getValue();
            code.add(this.parameterGenerator.generateParameterValue(value));
            code.add(")", new Object[0]);
            return code.build();
        }

        private void handlePropertyValues(MultiStatement statements, String bdVariable, PropertyValues propertyValues) {
            PropertyValue[] properties = propertyValues.getPropertyValues();
            if (properties.length == 1) {
                statements.addStatement(this.generatePropertyValue(bdVariable + ".getPropertyValues().", properties[0]));
            } else {
                String pvVariable = BeanRegistrationBeanFactoryContribution.this.determineVariableName("propertyValues");
                statements.addStatement("$T $L = $L.getPropertyValues()", new Object[]{MutablePropertyValues.class, pvVariable, bdVariable});
                for (PropertyValue property : properties) {
                    statements.addStatement(this.generatePropertyValue(pvVariable + ".", property));
                }
            }
        }

        private CodeBlock generatePropertyValue(String prefix, PropertyValue property) {
            CodeBlock.Builder code = CodeBlock.builder();
            code.add(prefix, new Object[0]);
            code.add("addPropertyValue($S, ", new Object[]{property.getName()});
            Object value = property.getValue();
            code.add(this.parameterGenerator.generateParameterValue(value));
            code.add(")", new Object[0]);
            return code.build();
        }

        private void handleAttributes(MultiStatement statements, String bdVariable) {
            String[] attributeNames = this.beanDefinition.attributeNames();
            Predicate<String> filter = BeanRegistrationBeanFactoryContribution.this.getAttributeFilter();
            for (String attributeName : attributeNames) {
                if (!filter.test(attributeName)) continue;
                Object value = this.beanDefinition.getAttribute(attributeName);
                CodeBlock.Builder code = CodeBlock.builder();
                code.add("$L.setAttribute($S, ", new Object[]{bdVariable, attributeName});
                code.add(this.parameterGenerator.generateParameterValue(value));
                code.add(")", new Object[0]);
                statements.addStatement(code.build());
            }
        }
    }
}

