/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.aot.generator.CodeContribution;
import org.springframework.aot.generator.DefaultCodeContribution;
import org.springframework.aot.generator.ProtectedAccess;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.generator.BeanInstantiationContribution;
import org.springframework.beans.factory.generator.BeanInstantiationGenerator;
import org.springframework.beans.factory.generator.InjectionGenerator;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.ClassUtils;

class DefaultBeanInstantiationGenerator
implements BeanInstantiationGenerator {
    private final Executable instanceCreator;
    private final List<BeanInstantiationContribution> contributions;
    private final InjectionGenerator injectionGenerator;
    private final ProtectedAccess.Options beanInstanceOptions;

    DefaultBeanInstantiationGenerator(Executable instanceCreator, List<BeanInstantiationContribution> contributions) {
        this.instanceCreator = instanceCreator;
        this.contributions = List.copyOf(contributions);
        this.injectionGenerator = new InjectionGenerator();
        this.beanInstanceOptions = ProtectedAccess.Options.defaults().useReflection(member -> false).assignReturnType(member -> !this.contributions.isEmpty()).build();
    }

    @Override
    public Executable getInstanceCreator() {
        return this.instanceCreator;
    }

    @Override
    public CodeContribution generateBeanInstantiation(RuntimeHints runtimeHints) {
        DefaultCodeContribution codeContribution = new DefaultCodeContribution(runtimeHints);
        codeContribution.protectedAccess().analyze((Member)this.instanceCreator, this.beanInstanceOptions);
        Executable executable = this.instanceCreator;
        if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            this.generateBeanInstantiation((CodeContribution)codeContribution, constructor);
        } else {
            executable = this.instanceCreator;
            if (executable instanceof Method) {
                Method method = (Method)executable;
                this.generateBeanInstantiation((CodeContribution)codeContribution, method);
            }
        }
        return codeContribution;
    }

    private void generateBeanInstantiation(CodeContribution codeContribution, Constructor<?> constructor) {
        Class declaringType = ClassUtils.getUserClass(constructor.getDeclaringClass());
        boolean innerClass = DefaultBeanInstantiationGenerator.isInnerClass(declaringType);
        boolean multiStatements = !this.contributions.isEmpty();
        int minArgs = DefaultBeanInstantiationGenerator.isInnerClass(declaringType) ? 2 : 1;
        CodeBlock.Builder code = CodeBlock.builder();
        if (!multiStatements && constructor.getParameterTypes().length < minArgs) {
            if (innerClass) {
                code.add("() -> beanFactory.getBean($T.class).new $L()", new Object[]{declaringType.getEnclosingClass(), declaringType.getSimpleName()});
            } else if (declaringType.getDeclaredConstructors().length > 1) {
                code.add("() -> new $T()", new Object[]{declaringType});
            } else {
                code.add("$T::new", new Object[]{declaringType});
            }
            codeContribution.statements().addStatement(code.build());
            return;
        }
        codeContribution.runtimeHints().reflection().registerConstructor(constructor, hint -> hint.withMode(ExecutableMode.INTROSPECT));
        code.add("(instanceContext) ->", new Object[0]);
        DefaultBeanInstantiationGenerator.branch(multiStatements, () -> code.beginControlFlow("", new Object[0]), () -> code.add(" ", new Object[0]));
        if (multiStatements) {
            code.add("$T bean = ", new Object[]{declaringType});
        }
        code.add(this.injectionGenerator.generateInstantiation(constructor));
        codeContribution.statements().addStatement(code.build());
        if (multiStatements) {
            for (BeanInstantiationContribution contribution : this.contributions) {
                contribution.applyTo(codeContribution);
            }
            codeContribution.statements().addStatement("return bean", new Object[0]).add(codeBlock -> codeBlock.unindent().add("}", new Object[0]));
        }
    }

    private static boolean isInnerClass(Class<?> type) {
        return type.isMemberClass() && !Modifier.isStatic(type.getModifiers());
    }

    private void generateBeanInstantiation(CodeContribution codeContribution, Method method) {
        codeContribution.runtimeHints().reflection().registerMethod(method, hint -> hint.withMode(ExecutableMode.INTROSPECT));
        ArrayList parameterTypes = new ArrayList(Arrays.asList(method.getParameterTypes()));
        boolean multiStatements = !this.contributions.isEmpty();
        Class<?> declaringType = method.getDeclaringClass();
        CodeBlock.Builder code = CodeBlock.builder();
        if (!multiStatements && parameterTypes.isEmpty()) {
            code.add("() -> ", new Object[0]);
            DefaultBeanInstantiationGenerator.branch(Modifier.isStatic(method.getModifiers()), () -> code.add("$T", new Object[]{declaringType}), () -> code.add("beanFactory.getBean($T.class)", new Object[]{declaringType}));
            code.add(".$L()", new Object[]{method.getName()});
            codeContribution.statements().addStatement(code.build());
            return;
        }
        code.add("(instanceContext) ->", new Object[0]);
        DefaultBeanInstantiationGenerator.branch(multiStatements, () -> code.beginControlFlow("", new Object[0]), () -> code.add(" ", new Object[0]));
        if (multiStatements) {
            code.add("$T bean = ", new Object[]{method.getReturnType()});
        }
        code.add(this.injectionGenerator.generateInstantiation(method));
        codeContribution.statements().addStatement(code.build());
        if (multiStatements) {
            for (BeanInstantiationContribution contribution : this.contributions) {
                contribution.applyTo(codeContribution);
            }
            codeContribution.statements().addStatement("return bean", new Object[0]).add(codeBlock -> codeBlock.unindent().add("}", new Object[0]));
        }
    }

    private static void branch(boolean condition, Runnable ifTrue, Runnable ifFalse) {
        if (condition) {
            ifTrue.run();
        } else {
            ifFalse.run();
        }
    }
}

