/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.generator.AotContributingBeanPostProcessor;
import org.springframework.beans.factory.generator.BeanInstantiationContribution;
import org.springframework.beans.factory.generator.BeanInstantiationGenerator;
import org.springframework.beans.factory.generator.BeanRegistrationBeanFactoryContribution;
import org.springframework.beans.factory.generator.BeanRegistrationContributionProvider;
import org.springframework.beans.factory.generator.DefaultBeanInstantiationGenerator;
import org.springframework.beans.factory.generator.InnerBeanRegistrationBeanFactoryContribution;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.OrderComparator;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.SingletonSupplier;

public final class DefaultBeanRegistrationContributionProvider
implements BeanRegistrationContributionProvider {
    private final DefaultListableBeanFactory beanFactory;
    private final ExecutableProvider executableProvider;
    private final Supplier<List<AotContributingBeanPostProcessor>> beanPostProcessors;

    public DefaultBeanRegistrationContributionProvider(DefaultListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.executableProvider = new ExecutableProvider(beanFactory);
        this.beanPostProcessors = new SingletonSupplier(null, () -> DefaultBeanRegistrationContributionProvider.loadAotContributingBeanPostProcessors(beanFactory));
    }

    private static List<AotContributingBeanPostProcessor> loadAotContributingBeanPostProcessors(DefaultListableBeanFactory beanFactory) {
        String[] postProcessorNames = beanFactory.getBeanNamesForType(AotContributingBeanPostProcessor.class, true, false);
        ArrayList<AotContributingBeanPostProcessor> postProcessors = new ArrayList<AotContributingBeanPostProcessor>();
        for (String ppName : postProcessorNames) {
            postProcessors.add(beanFactory.getBean(ppName, AotContributingBeanPostProcessor.class));
        }
        DefaultBeanRegistrationContributionProvider.sortPostProcessors(postProcessors, beanFactory);
        return postProcessors;
    }

    @Override
    public BeanRegistrationBeanFactoryContribution getContributionFor(String beanName, RootBeanDefinition beanDefinition) {
        BeanInstantiationGenerator beanInstantiationGenerator = this.getBeanInstantiationGenerator(beanName, beanDefinition);
        return new BeanRegistrationBeanFactoryContribution(beanName, beanDefinition, beanInstantiationGenerator, this);
    }

    public BeanInstantiationGenerator getBeanInstantiationGenerator(String beanName, RootBeanDefinition beanDefinition) {
        return new DefaultBeanInstantiationGenerator(this.determineExecutable(beanDefinition), this.determineBeanInstanceContributions(beanName, beanDefinition));
    }

    BeanRegistrationBeanFactoryContribution getInnerBeanRegistrationContribution(BeanRegistrationBeanFactoryContribution parent, BeanDefinition innerBeanDefinition) {
        BeanDefinitionValueResolver bdvr = new BeanDefinitionValueResolver(this.beanFactory, parent.getBeanName(), parent.getBeanDefinition());
        return bdvr.resolveInnerBean(null, innerBeanDefinition, (beanName, bd) -> new InnerBeanRegistrationBeanFactoryContribution((String)beanName, (RootBeanDefinition)bd, this.getBeanInstantiationGenerator((String)beanName, (RootBeanDefinition)bd), this));
    }

    private Executable determineExecutable(RootBeanDefinition beanDefinition) {
        Executable executable = this.executableProvider.detectBeanInstanceExecutable(beanDefinition);
        if (executable == null) {
            throw new IllegalStateException("No suitable executor found for " + beanDefinition);
        }
        return executable;
    }

    private List<BeanInstantiationContribution> determineBeanInstanceContributions(String beanName, RootBeanDefinition beanDefinition) {
        ArrayList<BeanInstantiationContribution> contributions = new ArrayList<BeanInstantiationContribution>();
        for (AotContributingBeanPostProcessor pp : this.beanPostProcessors.get()) {
            BeanInstantiationContribution contribution = pp.contribute(beanDefinition, beanDefinition.getResolvableType().toClass(), beanName);
            if (contribution == null) continue;
            contributions.add(contribution);
        }
        return contributions;
    }

    private static void sortPostProcessors(List<?> postProcessors, ConfigurableListableBeanFactory beanFactory) {
        if (postProcessors.size() <= 1) {
            return;
        }
        OrderComparator comparatorToUse = null;
        if (beanFactory instanceof DefaultListableBeanFactory) {
            comparatorToUse = ((DefaultListableBeanFactory)beanFactory).getDependencyComparator();
        }
        if (comparatorToUse == null) {
            comparatorToUse = OrderComparator.INSTANCE;
        }
        postProcessors.sort((Comparator<?>)comparatorToUse);
    }

    private static class ExecutableProvider {
        private static final Log logger = LogFactory.getLog(ExecutableProvider.class);
        private final ConfigurableBeanFactory beanFactory;
        private final ClassLoader classLoader;

        ExecutableProvider(ConfigurableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
            this.classLoader = beanFactory.getBeanClassLoader() != null ? beanFactory.getBeanClassLoader() : this.getClass().getClassLoader();
        }

        @Nullable
        Executable detectBeanInstanceExecutable(BeanDefinition beanDefinition) {
            Supplier<ResolvableType> beanType = () -> this.getBeanType(beanDefinition);
            List<ResolvableType> valueTypes = beanDefinition.hasConstructorArgumentValues() ? this.determineParameterValueTypes(beanDefinition.getConstructorArgumentValues()) : Collections.emptyList();
            Method resolvedFactoryMethod = this.resolveFactoryMethod(beanDefinition, valueTypes);
            if (resolvedFactoryMethod != null) {
                return resolvedFactoryMethod;
            }
            Class<?> factoryBeanClass = this.getFactoryBeanClass(beanDefinition);
            if (factoryBeanClass != null && !factoryBeanClass.equals(beanDefinition.getResolvableType().toClass())) {
                ResolvableType resolvableType = beanDefinition.getResolvableType();
                boolean isCompatible = ResolvableType.forClass(factoryBeanClass).as(FactoryBean.class).getGeneric(new int[]{0}).isAssignableFrom(resolvableType);
                if (isCompatible) {
                    return this.resolveConstructor(() -> ResolvableType.forClass((Class)factoryBeanClass), valueTypes);
                }
                throw new IllegalStateException(String.format("Incompatible target type '%s' for factory bean '%s'", resolvableType.toClass().getName(), factoryBeanClass.getName()));
            }
            Executable resolvedConstructor = this.resolveConstructor(beanType, valueTypes);
            if (resolvedConstructor != null) {
                return resolvedConstructor;
            }
            Executable resolvedConstructorOrFactoryMethod = this.getField(beanDefinition, "resolvedConstructorOrFactoryMethod", Executable.class);
            if (resolvedConstructorOrFactoryMethod != null) {
                logger.error((Object)("resolvedConstructorOrFactoryMethod required for " + beanDefinition));
                return resolvedConstructorOrFactoryMethod;
            }
            return null;
        }

        private List<ResolvableType> determineParameterValueTypes(ConstructorArgumentValues constructorArgumentValues) {
            ArrayList<ResolvableType> parameterTypes = new ArrayList<ResolvableType>();
            for (ConstructorArgumentValues.ValueHolder valueHolder : constructorArgumentValues.getIndexedArgumentValues().values()) {
                if (valueHolder.getType() != null) {
                    parameterTypes.add(ResolvableType.forClass(this.loadClass(valueHolder.getType())));
                    continue;
                }
                Object value = valueHolder.getValue();
                if (value instanceof BeanReference) {
                    parameterTypes.add(ResolvableType.forClass(this.beanFactory.getType(((BeanReference)value).getBeanName(), false)));
                    continue;
                }
                if (value instanceof BeanDefinition) {
                    parameterTypes.add(this.extractTypeFromBeanDefinition(this.getBeanType((BeanDefinition)value)));
                    continue;
                }
                parameterTypes.add(ResolvableType.forInstance((Object)value));
            }
            return parameterTypes;
        }

        private ResolvableType extractTypeFromBeanDefinition(ResolvableType type) {
            if (FactoryBean.class.isAssignableFrom(type.toClass())) {
                return type.as(FactoryBean.class).getGeneric(new int[]{0});
            }
            return type;
        }

        @Nullable
        private Method resolveFactoryMethod(BeanDefinition beanDefinition, List<ResolvableType> valueTypes) {
            RootBeanDefinition rbd;
            Method resolvedFactoryMethod;
            if (beanDefinition instanceof RootBeanDefinition && (resolvedFactoryMethod = (rbd = (RootBeanDefinition)beanDefinition).getResolvedFactoryMethod()) != null) {
                return resolvedFactoryMethod;
            }
            String factoryMethodName = beanDefinition.getFactoryMethodName();
            if (factoryMethodName != null) {
                ArrayList<Method> methods = new ArrayList<Method>();
                Class<?> beanClass = this.getBeanClass(beanDefinition);
                if (beanClass == null) {
                    throw new IllegalStateException("Failed to determine bean class of " + beanDefinition);
                }
                ReflectionUtils.doWithMethods(beanClass, methods::add, method -> this.isFactoryMethodCandidate(beanClass, method, factoryMethodName));
                if (methods.size() >= 1) {
                    Function<Method, List<ResolvableType>> parameterTypesFactory = method -> {
                        ArrayList<ResolvableType> types = new ArrayList<ResolvableType>();
                        for (int i = 0; i < method.getParameterCount(); ++i) {
                            types.add(ResolvableType.forMethodParameter((Method)method, (int)i));
                        }
                        return types;
                    };
                    return (Method)this.resolveFactoryMethod(methods, parameterTypesFactory, valueTypes);
                }
            }
            return null;
        }

        private boolean isFactoryMethodCandidate(Class<?> beanClass, Method method, String factoryMethodName) {
            if (method.getName().equals(factoryMethodName)) {
                if (Modifier.isStatic(method.getModifiers())) {
                    return method.getDeclaringClass().equals(beanClass);
                }
                return !Modifier.isPrivate(method.getModifiers());
            }
            return false;
        }

        @Nullable
        private Executable resolveConstructor(Supplier<ResolvableType> beanType, List<ResolvableType> valueTypes) {
            Class type = ClassUtils.getUserClass((Class)beanType.get().toClass());
            Constructor<?>[] constructors = type.getDeclaredConstructors();
            if (constructors.length == 1) {
                return constructors[0];
            }
            for (Constructor<?> constructor : constructors) {
                if (!MergedAnnotations.from(constructor).isPresent(Autowired.class)) continue;
                return constructor;
            }
            Function<Constructor, List> parameterTypesFactory = executable -> {
                ArrayList<ResolvableType> types = new ArrayList<ResolvableType>();
                for (int i = 0; i < executable.getParameterCount(); ++i) {
                    types.add(ResolvableType.forConstructorParameter((Constructor)executable, (int)i));
                }
                return types;
            };
            List<Constructor> matches = Arrays.stream(constructors).filter(executable -> this.match((List)parameterTypesFactory.apply((Constructor)executable), valueTypes, FallbackMode.NONE)).toList();
            if (matches.size() == 1) {
                return matches.get(0);
            }
            List<Constructor> assignableElementFallbackMatches = Arrays.stream(constructors).filter(executable -> this.match((List)parameterTypesFactory.apply((Constructor)executable), valueTypes, FallbackMode.ASSIGNABLE_ELEMENT)).toList();
            if (assignableElementFallbackMatches.size() == 1) {
                return assignableElementFallbackMatches.get(0);
            }
            List<Constructor> typeConversionFallbackMatches = Arrays.stream(constructors).filter(executable -> this.match((List)parameterTypesFactory.apply((Constructor)executable), valueTypes, FallbackMode.TYPE_CONVERSION)).toList();
            return typeConversionFallbackMatches.size() == 1 ? (Executable)typeConversionFallbackMatches.get(0) : null;
        }

        private Executable resolveFactoryMethod(List<Method> executables, Function<Method, List<ResolvableType>> parameterTypesFactory, List<ResolvableType> valueTypes) {
            List<Method> matches = executables.stream().filter(executable -> this.match((List)parameterTypesFactory.apply((Method)executable), valueTypes, FallbackMode.NONE)).toList();
            if (matches.size() == 1) {
                return matches.get(0);
            }
            List<Method> assignableElementFallbackMatches = executables.stream().filter(executable -> this.match((List)parameterTypesFactory.apply((Method)executable), valueTypes, FallbackMode.ASSIGNABLE_ELEMENT)).toList();
            if (assignableElementFallbackMatches.size() == 1) {
                return assignableElementFallbackMatches.get(0);
            }
            List<Method> typeConversionFallbackMatches = executables.stream().filter(executable -> this.match((List)parameterTypesFactory.apply((Method)executable), valueTypes, FallbackMode.TYPE_CONVERSION)).toList();
            if (typeConversionFallbackMatches.size() > 1) {
                throw new IllegalStateException("Multiple matches with parameters '" + valueTypes + "': " + typeConversionFallbackMatches);
            }
            return typeConversionFallbackMatches.size() == 1 ? (Executable)typeConversionFallbackMatches.get(0) : null;
        }

        private boolean match(List<ResolvableType> parameterTypes, List<ResolvableType> valueTypes, FallbackMode fallbackMode) {
            if (parameterTypes.size() != valueTypes.size()) {
                return false;
            }
            for (int i = 0; i < parameterTypes.size(); ++i) {
                if (this.isMatch(parameterTypes.get(i), valueTypes.get(i), fallbackMode)) continue;
                return false;
            }
            return true;
        }

        private boolean isMatch(ResolvableType parameterType, ResolvableType valueType, FallbackMode fallbackMode) {
            if (this.isAssignable(valueType).test(parameterType)) {
                return true;
            }
            return switch (fallbackMode) {
                case FallbackMode.ASSIGNABLE_ELEMENT -> this.isAssignable(valueType).test(this.extractElementType(parameterType));
                case FallbackMode.TYPE_CONVERSION -> this.typeConversionFallback(valueType).test(parameterType);
                default -> false;
            };
        }

        private Predicate<ResolvableType> isAssignable(ResolvableType valueType) {
            return parameterType -> {
                if (valueType.hasUnresolvableGenerics()) {
                    return parameterType.toClass().isAssignableFrom(valueType.toClass());
                }
                return parameterType.isAssignableFrom(valueType);
            };
        }

        private ResolvableType extractElementType(ResolvableType parameterType) {
            if (parameterType.isArray()) {
                return parameterType.getComponentType();
            }
            if (Collection.class.isAssignableFrom(parameterType.toClass())) {
                return parameterType.as(Collection.class).getGeneric(new int[]{0});
            }
            return ResolvableType.NONE;
        }

        private Predicate<ResolvableType> typeConversionFallback(ResolvableType valueType) {
            return parameterType -> {
                if (this.valueOrCollection(valueType, this::isStringForClassFallback).test((ResolvableType)parameterType)) {
                    return true;
                }
                return this.valueOrCollection(valueType, this::isSimpleConvertibleType).test((ResolvableType)parameterType);
            };
        }

        private Predicate<ResolvableType> valueOrCollection(ResolvableType valueType, Function<ResolvableType, Predicate<ResolvableType>> predicateProvider) {
            return parameterType -> {
                if (((Predicate)predicateProvider.apply(valueType)).test(parameterType)) {
                    return true;
                }
                if (((Predicate)predicateProvider.apply(this.extractElementType(valueType))).test(this.extractElementType((ResolvableType)parameterType))) {
                    return true;
                }
                return ((Predicate)predicateProvider.apply(valueType)).test(this.extractElementType((ResolvableType)parameterType));
            };
        }

        private Predicate<ResolvableType> isStringForClassFallback(ResolvableType valueType) {
            return parameterType -> valueType.isAssignableFrom(String.class) && parameterType.isAssignableFrom(Class.class);
        }

        private Predicate<ResolvableType> isSimpleConvertibleType(ResolvableType valueType) {
            return parameterType -> ExecutableProvider.isSimpleConvertibleType(parameterType.toClass()) && ExecutableProvider.isSimpleConvertibleType(valueType.toClass());
        }

        @Nullable
        private Class<?> getFactoryBeanClass(BeanDefinition beanDefinition) {
            RootBeanDefinition rbd;
            if (beanDefinition instanceof RootBeanDefinition && (rbd = (RootBeanDefinition)beanDefinition).hasBeanClass()) {
                Class<?> beanClass = rbd.getBeanClass();
                return FactoryBean.class.isAssignableFrom(beanClass) ? beanClass : null;
            }
            return null;
        }

        @Nullable
        private Class<?> getBeanClass(BeanDefinition beanDefinition) {
            if (beanDefinition instanceof AbstractBeanDefinition) {
                AbstractBeanDefinition abd = (AbstractBeanDefinition)beanDefinition;
                return abd.hasBeanClass() ? abd.getBeanClass() : this.loadClass(abd.getBeanClassName());
            }
            return beanDefinition.getBeanClassName() != null ? this.loadClass(beanDefinition.getBeanClassName()) : null;
        }

        private ResolvableType getBeanType(BeanDefinition beanDefinition) {
            RootBeanDefinition rbd;
            ResolvableType resolvableType = beanDefinition.getResolvableType();
            if (resolvableType != ResolvableType.NONE) {
                return resolvableType;
            }
            if (beanDefinition instanceof RootBeanDefinition && (rbd = (RootBeanDefinition)beanDefinition).hasBeanClass()) {
                return ResolvableType.forClass(rbd.getBeanClass());
            }
            String beanClassName = beanDefinition.getBeanClassName();
            if (beanClassName != null) {
                return ResolvableType.forClass(this.loadClass(beanClassName));
            }
            throw new IllegalStateException("Failed to determine bean class of " + beanDefinition);
        }

        private Class<?> loadClass(String beanClassName) {
            try {
                return ClassUtils.forName((String)beanClassName, (ClassLoader)this.classLoader);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Failed to load class " + beanClassName);
            }
        }

        @Nullable
        private <T> T getField(BeanDefinition beanDefinition, String fieldName, Class<T> targetType) {
            Field field = ReflectionUtils.findField(RootBeanDefinition.class, (String)fieldName);
            ReflectionUtils.makeAccessible((Field)field);
            return targetType.cast(ReflectionUtils.getField((Field)field, (Object)beanDefinition));
        }

        public static boolean isSimpleConvertibleType(Class<?> type) {
            return type.isPrimitive() && type != Void.TYPE || type == Double.class || type == Float.class || type == Long.class || type == Integer.class || type == Short.class || type == Character.class || type == Byte.class || type == Boolean.class || type == String.class;
        }

        static enum FallbackMode {
            NONE,
            ASSIGNABLE_ELEMENT,
            TYPE_CONVERSION;

        }
    }
}

