/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.aot.generator.ProtectedAccess;
import org.springframework.beans.factory.generator.BeanParameterGenerator;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class InjectionGenerator {
    private static final ProtectedAccess.Options FIELD_INJECTION_OPTIONS = ProtectedAccess.Options.defaults().useReflection(member -> Modifier.isPrivate(member.getModifiers())).build();
    private static final ProtectedAccess.Options METHOD_INJECTION_OPTIONS = ProtectedAccess.Options.defaults().useReflection(member -> false).build();
    private final BeanParameterGenerator parameterGenerator = new BeanParameterGenerator();

    public CodeBlock generateInstantiation(Executable creator) {
        if (creator instanceof Constructor) {
            Constructor constructor = (Constructor)creator;
            return this.generateConstructorInstantiation(constructor);
        }
        if (creator instanceof Method) {
            Method method = (Method)creator;
            return this.generateMethodInstantiation(method);
        }
        throw new IllegalArgumentException("Could not handle creator " + creator);
    }

    public CodeBlock generateInjection(Member member, boolean required) {
        if (member instanceof Method) {
            Method method = (Method)member;
            return this.generateMethodInjection(method, required);
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            return this.generateFieldInjection(field, required);
        }
        throw new IllegalArgumentException("Could not handle member " + member);
    }

    public ProtectedAccess.Options getProtectedAccessInjectionOptions(Member member) {
        if (member instanceof Method) {
            return METHOD_INJECTION_OPTIONS;
        }
        if (member instanceof Field) {
            return FIELD_INJECTION_OPTIONS;
        }
        throw new IllegalArgumentException("Could not handle member " + member);
    }

    private CodeBlock generateConstructorInstantiation(Constructor<?> creator) {
        CodeBlock.Builder code = CodeBlock.builder();
        Class declaringType = ClassUtils.getUserClass(creator.getDeclaringClass());
        boolean innerClass = InjectionGenerator.isInnerClass(declaringType);
        Class[] parameterTypes = (Class[])Arrays.stream(creator.getParameters()).map(Parameter::getType).toArray(Class[]::new);
        if (innerClass && parameterTypes.length == 1) {
            code.add("beanFactory.getBean($T.class).new $L()", new Object[]{declaringType.getEnclosingClass(), declaringType.getSimpleName()});
            return code.build();
        }
        if (parameterTypes.length == 0) {
            code.add("new $T()", new Object[]{declaringType});
            return code.build();
        }
        boolean isAmbiguous = Arrays.stream(creator.getDeclaringClass().getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == parameterTypes.length).count() > 1L;
        code.add("instanceContext.create(beanFactory, (attributes) ->", new Object[0]);
        List<CodeBlock> parameters = this.resolveParameters(creator.getParameters(), isAmbiguous);
        if (innerClass) {
            parameters.remove(0);
        }
        code.add(" ", new Object[0]);
        if (innerClass) {
            code.add("beanFactory.getBean($T.class).new $L(", new Object[]{declaringType.getEnclosingClass(), declaringType.getSimpleName()});
        } else {
            code.add("new $T(", new Object[]{declaringType});
        }
        for (int i = 0; i < parameters.size(); ++i) {
            code.add(parameters.get(i));
            if (i >= parameters.size() - 1) continue;
            code.add(", ", new Object[0]);
        }
        code.add(")", new Object[0]);
        code.add(")", new Object[0]);
        return code.build();
    }

    private static boolean isInnerClass(Class<?> type) {
        return type.isMemberClass() && !Modifier.isStatic(type.getModifiers());
    }

    private CodeBlock generateMethodInstantiation(Method injectionPoint) {
        if (injectionPoint.getParameterCount() == 0) {
            CodeBlock.Builder code2 = CodeBlock.builder();
            Class<?> declaringType = injectionPoint.getDeclaringClass();
            if (Modifier.isStatic(injectionPoint.getModifiers())) {
                code2.add("$T", new Object[]{declaringType});
            } else {
                code2.add("beanFactory.getBean($T.class)", new Object[]{declaringType});
            }
            code2.add(".$L()", new Object[]{injectionPoint.getName()});
            return code2.build();
        }
        return this.generateMethodInvocation(injectionPoint, code -> code.add(".create(beanFactory, (attributes) ->", new Object[0]), true);
    }

    private CodeBlock generateMethodInjection(Method injectionPoint, boolean required) {
        Consumer<CodeBlock.Builder> attributesResolver = code -> {
            if (required) {
                code.add(".invoke(beanFactory, (attributes) ->", new Object[0]);
            } else {
                code.add(".resolve(beanFactory, false).ifResolved((attributes) ->", new Object[0]);
            }
        };
        return this.generateMethodInvocation(injectionPoint, attributesResolver, false);
    }

    private CodeBlock generateMethodInvocation(Method injectionPoint, Consumer<CodeBlock.Builder> attributesResolver, boolean instantiation) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("instanceContext", new Object[0]);
        if (!instantiation) {
            code.add(".method($S, ", new Object[]{injectionPoint.getName()});
            code.add(this.parameterGenerator.generateExecutableParameterTypes(injectionPoint));
            code.add(")\n", new Object[0]).indent().indent();
        }
        attributesResolver.accept(code);
        Parameter[] methodParameters = injectionPoint.getParameters();
        boolean isAmbiguous = Arrays.stream(injectionPoint.getDeclaringClass().getDeclaredMethods()).filter(method -> method.getName().equals(injectionPoint.getName()) && method.getParameterCount() == methodParameters.length).count() > 1L;
        List<CodeBlock> parameters = this.resolveParameters(methodParameters, isAmbiguous);
        code.add(" ", new Object[0]);
        if (instantiation) {
            if (Modifier.isStatic(injectionPoint.getModifiers())) {
                code.add("$T", new Object[]{injectionPoint.getDeclaringClass()});
            } else {
                code.add("beanFactory.getBean($T.class)", new Object[]{injectionPoint.getDeclaringClass()});
            }
        } else {
            code.add("bean", new Object[0]);
        }
        code.add(".$L(", new Object[]{injectionPoint.getName()});
        code.add(CodeBlock.join(parameters, (String)", "));
        code.add(")", new Object[0]);
        code.add(")", new Object[0]);
        if (!instantiation) {
            code.unindent().unindent();
        }
        return code.build();
    }

    CodeBlock generateFieldInjection(Field injectionPoint, boolean required) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("instanceContext.field($S", new Object[]{injectionPoint.getName()});
        code.add(")\n", new Object[0]).indent().indent();
        if (required) {
            code.add(".invoke(beanFactory, (attributes) ->", new Object[0]);
        } else {
            code.add(".resolve(beanFactory, false).ifResolved((attributes) ->", new Object[0]);
        }
        boolean hasAssignment = Modifier.isPrivate(injectionPoint.getModifiers());
        if (hasAssignment) {
            code.beginControlFlow("", new Object[0]);
            String fieldName = String.format("%sField", injectionPoint.getName());
            code.addStatement("$T $L = $T.findField($T.class, $S)", new Object[]{Field.class, fieldName, ReflectionUtils.class, injectionPoint.getDeclaringClass(), injectionPoint.getName()});
            code.addStatement("$T.makeAccessible($L)", new Object[]{ReflectionUtils.class, fieldName});
            code.addStatement("$T.setField($L, bean, attributes.get(0))", new Object[]{ReflectionUtils.class, fieldName});
            code.unindent().add("}", new Object[0]);
        } else {
            code.add(" bean.$L = attributes.get(0)", new Object[]{injectionPoint.getName()});
        }
        code.add(")", new Object[0]).unindent().unindent();
        return code.build();
    }

    private List<CodeBlock> resolveParameters(Parameter[] parameters, boolean shouldCast) {
        ArrayList<CodeBlock> parameterValues = new ArrayList<CodeBlock>();
        for (int i = 0; i < parameters.length; ++i) {
            if (shouldCast) {
                parameterValues.add(CodeBlock.of((String)"attributes.get($L, $T.class)", (Object[])new Object[]{i, parameters[i].getType()}));
                continue;
            }
            parameterValues.add(CodeBlock.of((String)"attributes.get($L)", (Object[])new Object[]{i}));
        }
        return parameterValues;
    }
}

