/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generator.config;

import java.util.List;
import org.springframework.beans.factory.generator.config.BeanDefinitionRegistrar;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class InjectedElementAttributes {
    @Nullable
    private final List<Object> attributes;

    InjectedElementAttributes(@Nullable List<Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isResolved() {
        return this.attributes != null;
    }

    public void ifResolved(Runnable task) {
        if (this.isResolved()) {
            task.run();
        }
    }

    public void ifResolved(BeanDefinitionRegistrar.ThrowableConsumer<InjectedElementAttributes> attributes) {
        this.ifResolved(() -> attributes.accept(this));
    }

    public <T> T get(int index) {
        Assert.notNull(this.attributes, (String)"Attributes must not be null");
        return (T)this.attributes.get(index);
    }

    public <T> T get(int index, Class<T> type) {
        Assert.notNull(this.attributes, (String)"Attributes must not be null");
        return (T)this.attributes.get(index);
    }
}

