/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.aot.AotFactoriesLoader;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsCustomizer;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

class BeanDefinitionMethodGeneratorFactory {
    private static final Log logger = LogFactory.getLog(BeanDefinitionMethodGeneratorFactory.class);
    private final List<BeanRegistrationAotProcessor> aotProcessors;
    private final List<BeanRegistrationExcludeFilter> excludeFilters;
    private final List<BeanRegistrationCodeFragmentsCustomizer> codeGenerationCustomizers;

    BeanDefinitionMethodGeneratorFactory(ConfigurableListableBeanFactory beanFactory) {
        this(new AotFactoriesLoader(beanFactory));
    }

    BeanDefinitionMethodGeneratorFactory(AotFactoriesLoader loader) {
        this.aotProcessors = loader.load(BeanRegistrationAotProcessor.class);
        this.excludeFilters = loader.load(BeanRegistrationExcludeFilter.class);
        this.codeGenerationCustomizers = loader.load(BeanRegistrationCodeFragmentsCustomizer.class);
    }

    @Nullable
    BeanDefinitionMethodGenerator getBeanDefinitionMethodGenerator(RegisteredBean registeredBean, @Nullable String innerBeanPropertyName) {
        if (this.isExcluded(registeredBean)) {
            return null;
        }
        List<BeanRegistrationAotContribution> contributions = this.getAotContributions(registeredBean);
        return new BeanDefinitionMethodGenerator(this, registeredBean, innerBeanPropertyName, contributions, this.codeGenerationCustomizers);
    }

    private boolean isExcluded(RegisteredBean registeredBean) {
        if (this.isImplicitlyExcluded(registeredBean)) {
            return true;
        }
        for (BeanRegistrationExcludeFilter excludeFilter : this.excludeFilters) {
            if (!excludeFilter.isExcluded(registeredBean)) continue;
            logger.trace((Object)LogMessage.format((String)"Excluding registered bean '%s' from bean factory %s due to %s", (Object)registeredBean.getBeanName(), (Object)ObjectUtils.identityToString((Object)registeredBean.getBeanFactory()), (Object)excludeFilter.getClass().getName()));
            return true;
        }
        return false;
    }

    private boolean isImplicitlyExcluded(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        return BeanFactoryInitializationAotProcessor.class.isAssignableFrom(beanClass) || BeanRegistrationAotProcessor.class.isAssignableFrom(beanClass);
    }

    private List<BeanRegistrationAotContribution> getAotContributions(RegisteredBean registeredBean) {
        String beanName = registeredBean.getBeanName();
        ArrayList<BeanRegistrationAotContribution> contributions = new ArrayList<BeanRegistrationAotContribution>();
        for (BeanRegistrationAotProcessor aotProcessor : this.aotProcessors) {
            BeanRegistrationAotContribution contribution = aotProcessor.processAheadOfTime(registeredBean);
            if (contribution == null) continue;
            logger.trace((Object)LogMessage.format((String)"Adding bean registration AOT contribution %S from %S to '%S'", (Object)contribution.getClass().getName(), (Object)aotProcessor.getClass().getName(), (Object)beanName));
            contributions.add(contribution);
        }
        return contributions;
    }
}

