/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.MethodGenerator;
import org.springframework.aot.generate.MethodNameGenerator;
import org.springframework.beans.factory.aot.ResolvableTypeCodeGenerator;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.AnnotationSpec;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class BeanDefinitionPropertyValueCodeGenerator {
    static final CodeBlock NULL_VALUE_CODE_BLOCK = CodeBlock.of((String)"null", (Object[])new Object[0]);
    private final MethodGenerator methodGenerator;
    private final List<Delegate> delegates = List.of(new PrimitiveDelegate(), new StringDelegate(), new EnumDelegate(), new ClassDelegate(), new ResolvableTypeDelegate(), new ArrayDelegate(), new ManagedListDelegate(), new ManagedSetDelegate(), new ManagedMapDelegate(), new ListDelegate(), new SetDelegate(), new MapDelegate(), new BeanReferenceDelegate());

    BeanDefinitionPropertyValueCodeGenerator(MethodGenerator methodGenerator) {
        this.methodGenerator = methodGenerator;
    }

    CodeBlock generateCode(@Nullable Object value) {
        ResolvableType type = value != null ? ResolvableType.forInstance((Object)value) : ResolvableType.NONE;
        return this.generateCode(value, type);
    }

    private CodeBlock generateCode(@Nullable Object value, ResolvableType type) {
        if (value == null) {
            return NULL_VALUE_CODE_BLOCK;
        }
        for (Delegate delegate : this.delegates) {
            CodeBlock code = delegate.generateCode(value, type);
            if (code == null) continue;
            return code;
        }
        throw new IllegalArgumentException("'type' " + type + " must be supported for instance code generation");
    }

    @FunctionalInterface
    private static interface Delegate {
        @Nullable
        public CodeBlock generateCode(Object var1, ResolvableType var2);
    }

    private static class PrimitiveDelegate
    implements Delegate {
        private static final Map<Character, String> CHAR_ESCAPES = Map.of(Character.valueOf('\b'), "\\b", Character.valueOf('\t'), "\\t", Character.valueOf('\n'), "\\n", Character.valueOf('\f'), "\\f", Character.valueOf('\r'), "\\r", Character.valueOf('\"'), "\"", Character.valueOf('\''), "\\'", Character.valueOf('\\'), "\\\\");

        private PrimitiveDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Boolean || value instanceof Integer) {
                return CodeBlock.of((String)"$L", (Object[])new Object[]{value});
            }
            if (value instanceof Byte) {
                return CodeBlock.of((String)"(byte) $L", (Object[])new Object[]{value});
            }
            if (value instanceof Short) {
                return CodeBlock.of((String)"(short) $L", (Object[])new Object[]{value});
            }
            if (value instanceof Long) {
                return CodeBlock.of((String)"$LL", (Object[])new Object[]{value});
            }
            if (value instanceof Float) {
                return CodeBlock.of((String)"$LF", (Object[])new Object[]{value});
            }
            if (value instanceof Double) {
                return CodeBlock.of((String)"(double) $L", (Object[])new Object[]{value});
            }
            if (value instanceof Character) {
                Character character = (Character)value;
                return CodeBlock.of((String)"'$L'", (Object[])new Object[]{this.escape(character.charValue())});
            }
            return null;
        }

        private String escape(char ch) {
            String escaped = CHAR_ESCAPES.get(Character.valueOf(ch));
            if (escaped != null) {
                return escaped;
            }
            return !Character.isISOControl(ch) ? Character.toString(ch) : String.format("\\u%04x", ch);
        }
    }

    private static class StringDelegate
    implements Delegate {
        private StringDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof String) {
                return CodeBlock.of((String)"$S", (Object[])new Object[]{value});
            }
            return null;
        }
    }

    private static class EnumDelegate
    implements Delegate {
        private EnumDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Enum) {
                Enum enumValue = (Enum)value;
                return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{enumValue.getDeclaringClass(), enumValue.name()});
            }
            return null;
        }
    }

    private static class ClassDelegate
    implements Delegate {
        private ClassDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Class) {
                Class clazz = (Class)value;
                return CodeBlock.of((String)"$T.class", (Object[])new Object[]{ClassUtils.getUserClass((Class)clazz)});
            }
            return null;
        }
    }

    private static class ResolvableTypeDelegate
    implements Delegate {
        private ResolvableTypeDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof ResolvableType) {
                ResolvableType resolvableType = (ResolvableType)value;
                return ResolvableTypeCodeGenerator.generateCode(resolvableType);
            }
            return null;
        }
    }

    private class ArrayDelegate
    implements Delegate {
        private ArrayDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(@Nullable Object value, ResolvableType type) {
            if (type.isArray()) {
                ResolvableType componentType = type.getComponentType();
                int length = Array.getLength(value);
                CodeBlock.Builder builder = CodeBlock.builder();
                builder.add("new $T {", new Object[]{type.toClass()});
                for (int i = 0; i < length; ++i) {
                    Object component = Array.get(value, i);
                    if (i != 0) {
                        builder.add(", ", new Object[0]);
                    }
                    builder.add("$L", new Object[]{BeanDefinitionPropertyValueCodeGenerator.this.generateCode(component, componentType)});
                }
                builder.add("}", new Object[0]);
                return builder.build();
            }
            return null;
        }
    }

    private class ManagedListDelegate
    extends CollectionDelegate<ManagedList<?>> {
        public ManagedListDelegate() {
            super(ManagedList.class, CodeBlock.of((String)"new $T()", (Object[])new Object[]{ManagedList.class}));
        }
    }

    private class ManagedSetDelegate
    extends CollectionDelegate<ManagedSet<?>> {
        public ManagedSetDelegate() {
            super(ManagedSet.class, CodeBlock.of((String)"new $T()", (Object[])new Object[]{ManagedSet.class}));
        }
    }

    private class ManagedMapDelegate
    implements Delegate {
        private static final CodeBlock EMPTY_RESULT = CodeBlock.of((String)"$T.ofEntries()", (Object[])new Object[]{ManagedMap.class});

        private ManagedMapDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof ManagedMap) {
                ManagedMap managedMap = (ManagedMap)value;
                return this.generateManagedMapCode(type, managedMap);
            }
            return null;
        }

        private <K, V> CodeBlock generateManagedMapCode(ResolvableType type, ManagedMap<K, V> managedMap) {
            if (managedMap.isEmpty()) {
                return EMPTY_RESULT;
            }
            ResolvableType keyType = type.as(Map.class).getGeneric(new int[]{0});
            ResolvableType valueType = type.as(Map.class).getGeneric(new int[]{1});
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("$T.ofEntries(", new Object[]{ManagedMap.class});
            Iterator iterator = managedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                builder.add("$T.entry($L,$L)", new Object[]{Map.class, BeanDefinitionPropertyValueCodeGenerator.this.generateCode(entry.getKey(), keyType), BeanDefinitionPropertyValueCodeGenerator.this.generateCode(entry.getValue(), valueType)});
                if (!iterator.hasNext()) continue;
                builder.add(", ", new Object[0]);
            }
            builder.add(")", new Object[0]);
            return builder.build();
        }
    }

    private class ListDelegate
    extends CollectionDelegate<List<?>> {
        ListDelegate() {
            super(List.class, CodeBlock.of((String)"$T.emptyList()", (Object[])new Object[]{Collections.class}));
        }
    }

    private class SetDelegate
    extends CollectionDelegate<Set<?>> {
        SetDelegate() {
            super(Set.class, CodeBlock.of((String)"$T.emptySet()", (Object[])new Object[]{Collections.class}));
        }

        @Override
        protected CodeBlock generateCollectionCode(ResolvableType elementType, Set<?> set) {
            if (set instanceof LinkedHashSet) {
                return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{LinkedHashSet.class, this.generateCollectionOf(set, List.class, elementType)});
            }
            set = this.orderForCodeConsistency(set);
            return super.generateCollectionCode(elementType, set);
        }

        private Set<?> orderForCodeConsistency(Set<?> set) {
            return new TreeSet(set);
        }
    }

    private class MapDelegate
    implements Delegate {
        private static final CodeBlock EMPTY_RESULT = CodeBlock.of((String)"$T.emptyMap()", (Object[])new Object[]{Collections.class});

        private MapDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Map) {
                Map map = (Map)value;
                return this.generateMapCode(type, map);
            }
            return null;
        }

        private <K, V> CodeBlock generateMapCode(ResolvableType type, Map<K, V> map) {
            if (map.isEmpty()) {
                return EMPTY_RESULT;
            }
            ResolvableType keyType = type.as(Map.class).getGeneric(new int[]{0});
            ResolvableType valueType = type.as(Map.class).getGeneric(new int[]{1});
            if (map instanceof LinkedHashMap) {
                return this.generateLinkedHashMapCode(map, keyType, valueType);
            }
            boolean useOfEntries = (map = this.orderForCodeConsistency(map)).size() > 10;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("$T" + (!useOfEntries ? ".of(" : ".ofEntries("), new Object[]{Map.class});
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                CodeBlock keyCode = BeanDefinitionPropertyValueCodeGenerator.this.generateCode(entry.getKey(), keyType);
                CodeBlock valueCode = BeanDefinitionPropertyValueCodeGenerator.this.generateCode(entry.getValue(), valueType);
                if (!useOfEntries) {
                    builder.add("$L, $L", new Object[]{keyCode, valueCode});
                } else {
                    builder.add("$T.entry($L,$L)", new Object[]{Map.class, keyCode, valueCode});
                }
                if (!iterator.hasNext()) continue;
                builder.add(", ", new Object[0]);
            }
            builder.add(")", new Object[0]);
            return builder.build();
        }

        private <K, V> Map<K, V> orderForCodeConsistency(Map<K, V> map) {
            return new TreeMap<K, V>(map);
        }

        private <K, V> CodeBlock generateLinkedHashMapCode(Map<K, V> map, ResolvableType keyType, ResolvableType valueType) {
            GeneratedMethod method = BeanDefinitionPropertyValueCodeGenerator.this.methodGenerator.generateMethod(new Object[]{MethodNameGenerator.join((Object[])new Object[]{"get", "map"})}).using(builder -> {
                builder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{\"rawtypes\", \"unchecked\"}", new Object[0]).build());
                builder.returns(Map.class);
                builder.addStatement("$T map = new $T($L)", new Object[]{Map.class, LinkedHashMap.class, map.size()});
                map.forEach((key, value) -> builder.addStatement("map.put($L, $L)", new Object[]{BeanDefinitionPropertyValueCodeGenerator.this.generateCode(key, keyType), BeanDefinitionPropertyValueCodeGenerator.this.generateCode(value, valueType)}));
                builder.addStatement("return map", new Object[0]);
            });
            return CodeBlock.of((String)"$L()", (Object[])new Object[]{method.getName()});
        }
    }

    private static class BeanReferenceDelegate
    implements Delegate {
        private BeanReferenceDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof BeanReference) {
                BeanReference beanReference = (BeanReference)value;
                return CodeBlock.of((String)"new $T($S)", (Object[])new Object[]{RuntimeBeanReference.class, beanReference.getBeanName()});
            }
            return null;
        }
    }

    private abstract class CollectionDelegate<T extends Collection<?>>
    implements Delegate {
        private final Class<?> collectionType;
        private final CodeBlock emptyResult;

        public CollectionDelegate(Class<?> collectionType, CodeBlock emptyResult) {
            this.collectionType = collectionType;
            this.emptyResult = emptyResult;
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (this.collectionType.isInstance(value)) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    return this.emptyResult;
                }
                ResolvableType elementType = type.as(this.collectionType).getGeneric(new int[0]);
                return this.generateCollectionCode(elementType, collection);
            }
            return null;
        }

        protected CodeBlock generateCollectionCode(ResolvableType elementType, T collection) {
            return this.generateCollectionOf((Collection<?>)collection, this.collectionType, elementType);
        }

        protected final CodeBlock generateCollectionOf(Collection<?> collection, Class<?> collectionType, ResolvableType elementType) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("$T.of(", new Object[]{collectionType});
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                builder.add("$L", new Object[]{BeanDefinitionPropertyValueCodeGenerator.this.generateCode(element, elementType)});
                if (!iterator.hasNext()) continue;
                builder.add(", ", new Object[0]);
            }
            builder.add(")", new Object[0]);
            return builder.build();
        }
    }
}

