/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Executable;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.Assert;

public abstract class BeanRegistrationCodeFragments {
    protected static final String BEAN_DEFINITION_VARIABLE = "beanDefinition";
    protected static final String INSTANCE_SUPPLIER_VARIABLE = "instanceSupplier";
    private final BeanRegistrationCodeFragments codeFragments;

    protected BeanRegistrationCodeFragments(BeanRegistrationCodeFragments codeFragments) {
        Assert.notNull((Object)codeFragments, (String)"'codeFragments' must not be null");
        this.codeFragments = codeFragments;
    }

    BeanRegistrationCodeFragments() {
        this.codeFragments = null;
    }

    public Class<?> getTarget(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
        return this.codeFragments.getTarget(registeredBean, constructorOrFactoryMethod);
    }

    public CodeBlock generateNewBeanDefinitionCode(GenerationContext generationContext, ResolvableType beanType, BeanRegistrationCode beanRegistrationCode) {
        return this.codeFragments.generateNewBeanDefinitionCode(generationContext, beanType, beanRegistrationCode);
    }

    public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
        return this.codeFragments.generateSetBeanDefinitionPropertiesCode(generationContext, beanRegistrationCode, beanDefinition, attributeFilter);
    }

    public CodeBlock generateSetBeanInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, CodeBlock instanceSupplierCode, List<MethodReference> postProcessors) {
        return this.codeFragments.generateSetBeanInstanceSupplierCode(generationContext, beanRegistrationCode, instanceSupplierCode, postProcessors);
    }

    public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, Executable constructorOrFactoryMethod, boolean allowDirectSupplierShortcut) {
        return this.codeFragments.generateInstanceSupplierCode(generationContext, beanRegistrationCode, constructorOrFactoryMethod, allowDirectSupplierShortcut);
    }

    public CodeBlock generateReturnCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
        return this.codeFragments.generateReturnCode(generationContext, beanRegistrationCode);
    }
}

