/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.Map;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodGenerator;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.JavaFile;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.TypeSpec;

class BeanRegistrationsAotContribution
implements BeanFactoryInitializationAotContribution {
    private static final String BEAN_FACTORY_PARAMETER_NAME = "beanFactory";
    private final Map<String, BeanDefinitionMethodGenerator> registrations;

    BeanRegistrationsAotContribution(Map<String, BeanDefinitionMethodGenerator> registrations) {
        this.registrations = registrations;
    }

    @Override
    public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
        ClassName className = generationContext.getClassNameGenerator().generateClassName("BeanFactory", "Registrations");
        BeanRegistrationsCodeGenerator codeGenerator = new BeanRegistrationsCodeGenerator(className);
        GeneratedMethod registerMethod = codeGenerator.getMethodGenerator().generateMethod(new Object[]{"registerBeanDefinitions"}).using(builder -> this.generateRegisterMethod((MethodSpec.Builder)builder, generationContext, codeGenerator));
        JavaFile javaFile = codeGenerator.generatedJavaFile(className);
        generationContext.getGeneratedFiles().addSourceFile(javaFile);
        beanFactoryInitializationCode.addInitializer(MethodReference.of((ClassName)className, (String)registerMethod.getName()));
    }

    private void generateRegisterMethod(MethodSpec.Builder builder, GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        builder.addJavadoc("Register the bean definitions.", new Object[0]);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addParameter(DefaultListableBeanFactory.class, BEAN_FACTORY_PARAMETER_NAME, new Modifier[0]);
        CodeBlock.Builder code = CodeBlock.builder();
        this.registrations.forEach((beanName, beanDefinitionMethodGenerator) -> {
            MethodReference beanDefinitionMethod = beanDefinitionMethodGenerator.generateBeanDefinitionMethod(generationContext, beanRegistrationsCode);
            code.addStatement("$L.registerBeanDefinition($S, $L)", new Object[]{BEAN_FACTORY_PARAMETER_NAME, beanName, beanDefinitionMethod.toInvokeCodeBlock(new CodeBlock[0])});
        });
        builder.addCode(code.build());
    }

    static class BeanRegistrationsCodeGenerator
    implements BeanRegistrationsCode {
        private final ClassName className;
        private final GeneratedMethods generatedMethods = new GeneratedMethods();

        public BeanRegistrationsCodeGenerator(ClassName className) {
            this.className = className;
        }

        @Override
        public ClassName getClassName() {
            return this.className;
        }

        @Override
        public MethodGenerator getMethodGenerator() {
            return this.generatedMethods;
        }

        JavaFile generatedJavaFile(ClassName className) {
            TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)className);
            classBuilder.addJavadoc("Register bean definitions for the bean factory.", new Object[0]);
            classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
            this.generatedMethods.doWithMethodSpecs(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
            return JavaFile.builder((String)className.packageName(), (TypeSpec)classBuilder.build()).build();
        }
    }
}

